package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * iot酒店行业isv修改酒店信息
 *
 * @author auto create
 * @since 1.0, 2023-04-26 16:53:21
 */
public class AlipayOpenIotmbsIsvhotelModifyModel extends AlipayObject {

	private static final long serialVersionUID = 1629379382999925243L;

	/**
	 * appid+酒店关联的appid，后面相应的小程序调用相关组件时用于鉴权,多个appid之间用,分割
	 */
	@ApiField("appid")
	private String appid;

	/**
	 * ext_info+用于备注酒店
	 */
	@ApiField("ext_info")
	private String extInfo;

	/**
	 * project_addr+酒店项目所处的详细地址
	 */
	@ApiField("project_addr")
	private String projectAddr;

	/**
	 * project_flag用于标记创建的酒店是否是线上真实项目
	 */
	@ApiField("project_flag")
	private String projectFlag;

	/**
	 * project_id+需要编辑的酒店id
	 */
	@ApiField("project_id")
	private String projectId;

	/**
	 * project_name+isv定义的酒店名
	 */
	@ApiField("project_name")
	private String projectName;

	public String getAppid() {
		return this.appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getExtInfo() {
		return this.extInfo;
	}
	public void setExtInfo(String extInfo) {
		this.extInfo = extInfo;
	}

	public String getProjectAddr() {
		return this.projectAddr;
	}
	public void setProjectAddr(String projectAddr) {
		this.projectAddr = projectAddr;
	}

	public String getProjectFlag() {
		return this.projectFlag;
	}
	public void setProjectFlag(String projectFlag) {
		this.projectFlag = projectFlag;
	}

	public String getProjectId() {
		return this.projectId;
	}
	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return this.projectName;
	}
	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

}
