package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 检查蚂蚁操作员登录号是否存在
 *
 * @author auto create
 * @since 1.0, 2022-10-27 17:39:36
 */
public class AlipayOpenAuthOperatorLogonidCheckavailableModel extends AlipayObject {

	private static final long serialVersionUID = 4127373848466861927L;

	/**
	 * 操作员登录号类型。
枚举值参考LogonIdTypeEnum 范围如下：
1=手机号
2=Email
3=企业操作员昵称方式
	 */
	@ApiField("logon_id_type")
	private String logonIdType;

	/**
	 * 待验证的操作员登录号列表。一次最多验证20个
	 */
	@ApiListField("logon_ids")
	@ApiField("string")
	private List<String> logonIds;

	/**
	 * 指定租户ID，新增值需联系蚂蚁操作员operator团队人工处理
	 */
	@ApiField("tenant_id")
	private String tenantId;

	public String getLogonIdType() {
		return this.logonIdType;
	}
	public void setLogonIdType(String logonIdType) {
		this.logonIdType = logonIdType;
	}

	public List<String> getLogonIds() {
		return this.logonIds;
	}
	public void setLogonIds(List<String> logonIds) {
		this.logonIds = logonIds;
	}

	public String getTenantId() {
		return this.tenantId;
	}
	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

}
