package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 应用授权查询
 *
 * @author auto create
 * @since 1.0, 2022-05-13 17:22:45
 */
public class AlipayOpenAuthAppauthQueryModel extends AlipayObject {

	private static final long serialVersionUID = 7649716542833166341L;

	/**
	 * 插件订购场景中，插件所属的应用id
	 */
	@ApiField("agent_app_id")
	private String agentAppId;

	/**
	 * 商户应用在开放平台的应用id
	 */
	@ApiField("auth_app_id")
	private String authAppId;

	/**
	 * 授权token
	 */
	@ApiField("auth_token")
	private String authToken;

	/**
	 * isv的应用id
	 */
	@ApiField("isv_app_id")
	private String isvAppId;

	/**
	 * 分页查询的页码
	 */
	@ApiField("page_num")
	private Long pageNum;

	/**
	 * 分页查询的单页条目数量
	 */
	@ApiField("page_size")
	private Long pageSize;

	public String getAgentAppId() {
		return this.agentAppId;
	}
	public void setAgentAppId(String agentAppId) {
		this.agentAppId = agentAppId;
	}

	public String getAuthAppId() {
		return this.authAppId;
	}
	public void setAuthAppId(String authAppId) {
		this.authAppId = authAppId;
	}

	public String getAuthToken() {
		return this.authToken;
	}
	public void setAuthToken(String authToken) {
		this.authToken = authToken;
	}

	public String getIsvAppId() {
		return this.isvAppId;
	}
	public void setIsvAppId(String isvAppId) {
		this.isvAppId = isvAppId;
	}

	public Long getPageNum() {
		return this.pageNum;
	}
	public void setPageNum(Long pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

}
