package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 综合绑定门店
 *
 * @author auto create
 * @since 1.0, 2020-07-23 10:25:52
 */
public class AlipayOpenAppContentBindModel extends AlipayObject {

	private static final long serialVersionUID = 1581932594365838981L;

	/**
	 * 被绑定的实体的ID列表，一次请求不允许超过10个ID
	 */
	@ApiListField("bind_content_id_list")
	@ApiField("string")
	private List<String> bindContentIdList;

	/**
	 * 被绑定的实体类型，包括：支付宝商品、支付宝门店、商家POI、高德POI。对应枚举为：ALIPAY_ITEM、ALIPAY_SHOP、MERCHANT_POI、AMAP_POI
	 */
	@ApiField("bind_content_type")
	private String bindContentType;

	/**
	 * 绑定类型：小程序绑定门店、服务绑定门店、商品绑定门店、服务绑定商品。对应的枚举类型为：MINI_APP_BIND_SHOP、FUNCTION_BIND_SHOP、ITEM_BIND_SHOP、FUNCTION_BIND_ITEM
	 */
	@ApiField("bind_type")
	private String bindType;

	/**
	 * 进行绑定操作的实体编码：小程序绑定门店，content_id为该小程序编码；服务绑定门店或服务绑定商品，content_id为该服务的编码；商品绑定门店，content_id为该商品的编码
	 */
	@ApiField("content_id")
	private String contentId;

	public List<String> getBindContentIdList() {
		return this.bindContentIdList;
	}
	public void setBindContentIdList(List<String> bindContentIdList) {
		this.bindContentIdList = bindContentIdList;
	}

	public String getBindContentType() {
		return this.bindContentType;
	}
	public void setBindContentType(String bindContentType) {
		this.bindContentType = bindContentType;
	}

	public String getBindType() {
		return this.bindType;
	}
	public void setBindType(String bindType) {
		this.bindType = bindType;
	}

	public String getContentId() {
		return this.contentId;
	}
	public void setContentId(String contentId) {
		this.contentId = contentId;
	}

}
