package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 订单退款前向商户确认回调
 *
 * @author auto create
 * @since 1.0, 2023-02-12 16:52:19
 */
public class AlipayMarketingActivityOrderSubmitModel extends AlipayObject {

	private static final long serialVersionUID = 5452652551814845229L;

	/**
	 * 买家的支付宝uid
	 */
	@ApiField("buyer_id")
	private String buyerId;

	/**
	 * 买家的支付宝openId
	 */
	@ApiField("buyer_open_id")
	private String buyerOpenId;

	/**
	 * 购买商家兑换券的营销订单号
	 */
	@ApiField("order_no")
	private String orderNo;

	/**
	 * 退款前确认活动确认结果列表
	 */
	@ApiListField("refund_confirm_activity_info_list")
	@ApiField("refund_confirm_activity_info")
	private List<RefundConfirmActivityInfo> refundConfirmActivityInfoList;

	public String getBuyerId() {
		return this.buyerId;
	}
	public void setBuyerId(String buyerId) {
		this.buyerId = buyerId;
	}

	public String getBuyerOpenId() {
		return this.buyerOpenId;
	}
	public void setBuyerOpenId(String buyerOpenId) {
		this.buyerOpenId = buyerOpenId;
	}

	public String getOrderNo() {
		return this.orderNo;
	}
	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public List<RefundConfirmActivityInfo> getRefundConfirmActivityInfoList() {
		return this.refundConfirmActivityInfoList;
	}
	public void setRefundConfirmActivityInfoList(List<RefundConfirmActivityInfo> refundConfirmActivityInfoList) {
		this.refundConfirmActivityInfoList = refundConfirmActivityInfoList;
	}

}
