package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 会话转接
 *
 * @author auto create
 * @since 1.0, 2022-03-17 15:18:11
 */
public class AlipayIserviceCliveConnectTransferModel extends AlipayObject {

	private static final long serialVersionUID = 7133547856398612288L;

	/**
	 * 工作台统一分配会话id
	 */
	@ApiField("conversation_id")
	private String conversationId;

	/**
	 * 备注
	 */
	@ApiField("memo")
	private String memo;

	/**
	 * 技能组为指定小二模式使用，外部传入指定小二id
	 */
	@ApiField("server_id")
	private String serverId;

	/**
	 * 目标技能组id
	 */
	@ApiField("target_group_id")
	private String targetGroupId;

	/**
	 * 访客id，不强制要求2088体系
	 */
	@ApiField("visitor_id")
	private String visitorId;

	/**
	 * 工作台分配的访客token
	 */
	@ApiField("visitor_token")
	private String visitorToken;

	public String getConversationId() {
		return this.conversationId;
	}
	public void setConversationId(String conversationId) {
		this.conversationId = conversationId;
	}

	public String getMemo() {
		return this.memo;
	}
	public void setMemo(String memo) {
		this.memo = memo;
	}

	public String getServerId() {
		return this.serverId;
	}
	public void setServerId(String serverId) {
		this.serverId = serverId;
	}

	public String getTargetGroupId() {
		return this.targetGroupId;
	}
	public void setTargetGroupId(String targetGroupId) {
		this.targetGroupId = targetGroupId;
	}

	public String getVisitorId() {
		return this.visitorId;
	}
	public void setVisitorId(String visitorId) {
		this.visitorId = visitorId;
	}

	public String getVisitorToken() {
		return this.visitorToken;
	}
	public void setVisitorToken(String visitorToken) {
		this.visitorToken = visitorToken;
	}

}
