package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 查询联营卡用户拥有的卡信息列表
 *
 * @author auto create
 * @since 1.0, 2021-05-13 16:45:49
 */
public class AlipayFinancialnetAuthUnioncardInfoBatchqueryModel extends AlipayObject {

	private static final long serialVersionUID = 4455373457196153548L;

	/**
	 * 联营卡信息业务id，联营卡发卡场景下通过biz_type+biz_no能够唯一确定一张联营卡信息，因此传入该参数来获取指定卡的信息，通过接口alipay.financialnet.auth.unioncard.info.batchquery获取
	 */
	@ApiField("biz_no")
	private String bizNo;

	/**
	 * 联营卡发卡类型，联营卡发卡场景下通过该参数查询用户指定类型的卡信息列表，例如饿了么联营卡应填入ELM_U_CARD，由联营卡发卡平台同学定义
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * 联营卡发卡机构id，联营卡发卡场景下通过该参数过滤指定银行的联营卡信息，例如宁波银行填入NBBANK，通过联营卡发卡平台同学获取该值
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 外部合作方传入的用户id，联营卡用户通过该参数查询指定用户的卡信息列表。外部合作方发卡申请时会传入此字段
	 */
	@ApiField("out_user_id")
	private String outUserId;

	/**
	 * 接入业务场景id，联营卡发卡场景下填入固定值UNION_CARD_APPLY
	 */
	@ApiField("scene_id")
	private String sceneId;

	/**
	 * 来源编码，联营卡查询时通过此参数过滤出指定来源的卡信息，例如ELM标识为饿了么。在接入联营卡申请时，联系联营卡发卡平台同学获取该参数
	 */
	@ApiField("source_code")
	private String sourceCode;

	public String getBizNo() {
		return this.bizNo;
	}
	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getOutUserId() {
		return this.outUserId;
	}
	public void setOutUserId(String outUserId) {
		this.outUserId = outUserId;
	}

	public String getSceneId() {
		return this.sceneId;
	}
	public void setSceneId(String sceneId) {
		this.sceneId = sceneId;
	}

	public String getSourceCode() {
		return this.sourceCode;
	}
	public void setSourceCode(String sourceCode) {
		this.sourceCode = sourceCode;
	}

}
