package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 校验明文卡号卡bin信息并缓存明文卡号、cvv2、有效期等信息
 *
 * @author auto create
 * @since 1.0, 2022-11-11 13:21:25
 */
public class AlipayFinancialnetAuthCardinfoSaveModel extends AlipayObject {

	private static final long serialVersionUID = 5527598369184335798L;

	/**
	 * 明文卡号不支持索引卡号
	 */
	@ApiField("card_no")
	private String cardNo;

	/**
	 * 是否校验卡bin信息，不为true 不校验
	 */
	@ApiField("check_card_bin")
	private Boolean checkCardBin;

	/**
	 * 信用卡的cvv2信息
	 */
	@ApiField("cvv_2")
	private String cvv2;

	/**
	 * 信用卡上的有效期
	 */
	@ApiField("valid_date")
	private String validDate;

	public String getCardNo() {
		return this.cardNo;
	}
	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public Boolean getCheckCardBin() {
		return this.checkCardBin;
	}
	public void setCheckCardBin(Boolean checkCardBin) {
		this.checkCardBin = checkCardBin;
	}

	public String getCvv2() {
		return this.cvv2;
	}
	public void setCvv2(String cvv2) {
		this.cvv2 = cvv2;
	}

	public String getValidDate() {
		return this.validDate;
	}
	public void setValidDate(String validDate) {
		this.validDate = validDate;
	}

}
