package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝租车外部订单同步
 *
 * @author auto create
 * @since 1.0, 2023-07-10 12:26:27
 */
public class AlipayEcoMycarRentcarOutorderSyncModel extends AlipayObject {

	private static final long serialVersionUID = 2388861489923519547L;

	/**
	 * 车生活车型id
	 */
	@ApiField("carlife_vehicle_id")
	private String carlifeVehicleId;

	/**
	 * 还车门店名称
	 */
	@ApiField("drop_off_store_name")
	private String dropOffStoreName;

	/**
	 * 还车时间，精确到分，日期格式yyyy-MM-dd HH:mm
	 */
	@ApiField("drop_off_time")
	private String dropOffTime;

	/**
	 * 用户支付宝开放id
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 状态机与车生活订单同步的状态机保持一致，详情见 https://adccloud.yuque.com/adccloud/aqkbzc/bg8fiw#BE7wh
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 外部三方服务商的租车订单号
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/**
	 * 取车门店名称
	 */
	@ApiField("pick_up_store_name")
	private String pickUpStoreName;

	/**
	 * 取车时间，精确到分钟，日期格式yyyy-MM-dd HH:mm
	 */
	@ApiField("pick_up_time")
	private String pickUpTime;

	/**
	 * 订单总价，单位分，例如订单总价200元，传20000
	 */
	@ApiField("total_amount")
	private Long totalAmount;

	public String getCarlifeVehicleId() {
		return this.carlifeVehicleId;
	}
	public void setCarlifeVehicleId(String carlifeVehicleId) {
		this.carlifeVehicleId = carlifeVehicleId;
	}

	public String getDropOffStoreName() {
		return this.dropOffStoreName;
	}
	public void setDropOffStoreName(String dropOffStoreName) {
		this.dropOffStoreName = dropOffStoreName;
	}

	public String getDropOffTime() {
		return this.dropOffTime;
	}
	public void setDropOffTime(String dropOffTime) {
		this.dropOffTime = dropOffTime;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOutOrderId() {
		return this.outOrderId;
	}
	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public String getPickUpStoreName() {
		return this.pickUpStoreName;
	}
	public void setPickUpStoreName(String pickUpStoreName) {
		this.pickUpStoreName = pickUpStoreName;
	}

	public String getPickUpTime() {
		return this.pickUpTime;
	}
	public void setPickUpTime(String pickUpTime) {
		this.pickUpTime = pickUpTime;
	}

	public Long getTotalAmount() {
		return this.totalAmount;
	}
	public void setTotalAmount(Long totalAmount) {
		this.totalAmount = totalAmount;
	}

}
