package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 服务商品退款
 *
 * @author auto create
 * @since 1.0, 2023-06-29 10:17:09
 */
public class AlipayEcoMycarCommercializationOrderRefundModel extends AlipayObject {

	private static final long serialVersionUID = 8451638159569411514L;

	/**
	 * 凭证列表
	 */
	@ApiListField("certificate_list")
	@ApiField("certificate_item")
	private List<CertificateItem> certificateList;

	/**
	 * openid
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 支付宝侧订单id
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 退款流水号
	 */
	@ApiField("out_refund_no")
	private String outRefundNo;

	/**
	 * 退款金额，单位分
	 */
	@ApiField("refund_amount")
	private String refundAmount;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public List<CertificateItem> getCertificateList() {
		return this.certificateList;
	}
	public void setCertificateList(List<CertificateItem> certificateList) {
		this.certificateList = certificateList;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutRefundNo() {
		return this.outRefundNo;
	}
	public void setOutRefundNo(String outRefundNo) {
		this.outRefundNo = outRefundNo;
	}

	public String getRefundAmount() {
		return this.refundAmount;
	}
	public void setRefundAmount(String refundAmount) {
		this.refundAmount = refundAmount;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
