package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 充值结果消息异步通知
 *
 * @author auto create
 * @since 1.0, 2022-05-09 16:37:27
 */
public class AlipayEbppTopupOrderSyncModel extends AlipayObject {

	private static final long serialVersionUID = 5456337974712666383L;

	/**
	 * 支付宝订单号
	 */
	@ApiField("alipay_order_id")
	private String alipayOrderId;

	/**
	 * 商家充值时间
	 */
	@ApiField("charge_time")
	private String chargeTime;

	/**
	 * 机构侧分配的商家id
	 */
	@ApiField("merchant_id")
	private String merchantId;

	/**
	 * 商家发出通知时间
	 */
	@ApiField("notify_time")
	private String notifyTime;

	/**
	 * 商家订单号，机构必须保证同一个alipay_order_id永远只对应一个out_order_id
	 */
	@ApiField("out_order_no")
	private String outOrderNo;

	/**
	 * 供应商的订单状态，下单响应可选值如下：
SUCCESS 充值成功
FAILED 充值失败，该状态需要描述失败码和失败原因
	 */
	@ApiField("out_order_status")
	private String outOrderStatus;

	/**
	 * 充值失败时返回的结果码
	 */
	@ApiField("result_code")
	private String resultCode;

	/**
	 * 充值失败时返回的结果信息
	 */
	@ApiField("result_msg")
	private String resultMsg;

	public String getAlipayOrderId() {
		return this.alipayOrderId;
	}
	public void setAlipayOrderId(String alipayOrderId) {
		this.alipayOrderId = alipayOrderId;
	}

	public String getChargeTime() {
		return this.chargeTime;
	}
	public void setChargeTime(String chargeTime) {
		this.chargeTime = chargeTime;
	}

	public String getMerchantId() {
		return this.merchantId;
	}
	public void setMerchantId(String merchantId) {
		this.merchantId = merchantId;
	}

	public String getNotifyTime() {
		return this.notifyTime;
	}
	public void setNotifyTime(String notifyTime) {
		this.notifyTime = notifyTime;
	}

	public String getOutOrderNo() {
		return this.outOrderNo;
	}
	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}

	public String getOutOrderStatus() {
		return this.outOrderStatus;
	}
	public void setOutOrderStatus(String outOrderStatus) {
		this.outOrderStatus = outOrderStatus;
	}

	public String getResultCode() {
		return this.resultCode;
	}
	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getResultMsg() {
		return this.resultMsg;
	}
	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}

}
