package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 工单事件通知接口
 *
 * @author auto create
 * @since 1.0, 2020-06-17 19:58:38
 */
public class AlipayEbppInvoiceTopregisterActionSyncModel extends AlipayObject {

	private static final long serialVersionUID = 3487997698337327115L;

	/**
	 * 事件，可选值：create: 创建工单, isp_audit: 系统/小二审核通过, isv_agree: 服务商接单, isv_reject: 服务商驳回工单, confirm_qualification: 商户确认获取电子发票资质, fill_delivery_address: 商家填写税控设备收获地址, confirm_published: 服务商回传发行完毕, user_send_device: 商家确认已发出税控设备, machine_room_received: 服务商确认已收到税控设备, refund_start: 发起退款, refund_agree: 服务商拒绝退款, refund_reject: 服务商拒绝退单, device_deploy: 税控设备上架部署完成, inv_test_start: 开始测试开票, inv_test_success: 开票结果回传：开票成功, inv_test_fail: 开票结果回传：开票失败, confirm_test_success: 确认测试开票成功。proxy_sync_ca: ISV同步CA与签章信息至税控应用proxy_sync_company: ISV触发税控应用进行企业信息同步
	 */
	@ApiField("action")
	private String action;

	/**
	 * 扩展信息，json格式，键值可取：描述信息：message，服务生效时间：serv_start_time，服务结束时间：serv_end_time；当action为confirm_test_success时，需传入服务生效时间serv_start_time和服务结束时间serv_end_time
	 */
	@ApiField("ext_json")
	private String extJson;

	/**
	 * 入驻工单ID
	 */
	@ApiField("register_id")
	private String registerId;

	public String getAction() {
		return this.action;
	}
	public void setAction(String action) {
		this.action = action;
	}

	public String getExtJson() {
		return this.extJson;
	}
	public void setExtJson(String extJson) {
		this.extJson = extJson;
	}

	public String getRegisterId() {
		return this.registerId;
	}
	public void setRegisterId(String registerId) {
		this.registerId = registerId;
	}

}
