package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 开票结果查询接口
 *
 * @author auto create
 * @since 1.0, 2022-06-10 17:28:42
 */
public class AlipayEbppInvoiceTopeinvResultGetModel extends AlipayObject {

	private static final long serialVersionUID = 5536887166593827446L;

	/**
	 * 销方税号
	 */
	@ApiField("payee_register_no")
	private String payeeRegisterNo;

	/**
	 * 业务平台code, 由发票中台分配
	 */
	@ApiField("platform_code")
	private String platformCode;

	/**
	 * 业务平台对应的订单号。erial_no与platform_tid都不为空时，根据serial_no查询
	 */
	@ApiField("platform_tid")
	private String platformTid;

	/**
	 * 业务平台商户ID/卖家用户ID，用于归集发票
	 */
	@ApiField("platform_user_id")
	private String platformUserId;

	/**
	 * 开票流水号。 serial_no与platform_tid都不为空时，根据serial_no查询
	 */
	@ApiField("serial_no")
	private String serialNo;

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}
	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPlatformCode() {
		return this.platformCode;
	}
	public void setPlatformCode(String platformCode) {
		this.platformCode = platformCode;
	}

	public String getPlatformTid() {
		return this.platformTid;
	}
	public void setPlatformTid(String platformTid) {
		this.platformTid = platformTid;
	}

	public String getPlatformUserId() {
		return this.platformUserId;
	}
	public void setPlatformUserId(String platformUserId) {
		this.platformUserId = platformUserId;
	}

	public String getSerialNo() {
		return this.serialNo;
	}
	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

}
