package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 账单开票申请结果完结
 *
 * @author auto create
 * @since 1.0, 2021-04-06 11:40:20
 */
public class AlipayEbppInvoiceStandardApplyFinishModel extends AlipayObject {

	private static final long serialVersionUID = 2242617198692573197L;

	/**
	 * 支付宝发起开票申请的id，该id具有唯一性
	 */
	@ApiField("apply_id")
	private String applyId;

	/**
	 * 外部申请id，由开票服务方生成，该id在开票服务方具有唯一性
	 */
	@ApiField("out_apply_id")
	private String outApplyId;

	/**
	 * 开票申请处理结果
 - FAIL:开票处理失败
 - SUCCESS:开票处理成功
	 */
	@ApiField("result")
	private String result;

	/**
	 * 失败时要求必填，对应开票结果进行详细说明的结果码
	 */
	@ApiField("result_code")
	private String resultCode;

	/**
	 * 失败时要求必填，开票结果详细描述。示例：税控设备离线异常
	 */
	@ApiField("result_msg")
	private String resultMsg;

	public String getApplyId() {
		return this.applyId;
	}
	public void setApplyId(String applyId) {
		this.applyId = applyId;
	}

	public String getOutApplyId() {
		return this.outApplyId;
	}
	public void setOutApplyId(String outApplyId) {
		this.outApplyId = outApplyId;
	}

	public String getResult() {
		return this.result;
	}
	public void setResult(String result) {
		this.result = result;
	}

	public String getResultCode() {
		return this.resultCode;
	}
	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getResultMsg() {
		return this.resultMsg;
	}
	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}

}
