package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 创单
 *
 * @author auto create
 * @since 1.0, 2022-09-19 11:40:35
 */
public class AlipayEbppIndustryPerformOrderCreateModel extends AlipayObject {

	private static final long serialVersionUID = 8322663429315866855L;

	/**
	 * 通过支付宝收银台支付的资产
	 */
	@ApiField("alipay_trade_asset")
	private TradeAssetRequest alipayTradeAsset;

	/**
	 * 账单金额(订单原价，金额分)
	 */
	@ApiField("bill_amount")
	private String billAmount;

	/**
	 * 业务自定义扩展字段
	 */
	@ApiField("business_field")
	private String businessField;

	/**
	 * 创单类型
	 */
	@ApiField("create_type")
	private String createType;

	/**
	 * 滞纳金
	 */
	@ApiField("fine_amount")
	private String fineAmount;

	/**
	 * 机构code,如果多个机构公用一个instPid的业务则该字段必填
	 */
	@ApiField("inst_code")
	private String instCode;

	/**
	 * 机构pid
	 */
	@ApiField("inst_pid")
	private String instPid;

	/**
	 * 外部商品id
	 */
	@ApiField("item_id")
	private String itemId;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 外部唯一订单号
	 */
	@ApiField("out_no")
	private String outNo;

	/**
	 * 域外资产类型
	 */
	@ApiField("out_trade_assets")
	private PerFormTradeMap outTradeAssets;

	/**
	 * 如果是入驻的商户模式（SUB_MERCHANT），可以设置此参数进行分账
	 */
	@ApiListField("profit_sharing_list")
	@ApiField("profit_sharing_request")
	private List<ProfitSharingRequest> profitSharingList;

	/**
	 * 场景
	 */
	@ApiField("scene")
	private String scene;

	/**
	 * 服务载体(户号\卡号\手机号等)
	 */
	@ApiField("service_account")
	private String serviceAccount;

	/**
	 * 服务code
	 */
	@ApiField("service_code")
	private String serviceCode;

	/**
	 * 三方服务费
	 */
	@ApiField("third_amount")
	private String thirdAmount;

	/**
	 * 销账超时退款时间 单位秒
外部传入则以传入时间为准，否则以系统默认设置时间为准
	 */
	@ApiField("timeout_charge_off")
	private Long timeoutChargeOff;

	/**
	 * 订单超时关单时间 单位秒
外部传入则以传入时间为准，否则以系统默认设置时间为准
	 */
	@ApiField("timeout_close")
	private Long timeoutClose;

	/**
	 * 账单拥有者姓名
	 */
	@ApiField("user_name")
	private String userName;

	public TradeAssetRequest getAlipayTradeAsset() {
		return this.alipayTradeAsset;
	}
	public void setAlipayTradeAsset(TradeAssetRequest alipayTradeAsset) {
		this.alipayTradeAsset = alipayTradeAsset;
	}

	public String getBillAmount() {
		return this.billAmount;
	}
	public void setBillAmount(String billAmount) {
		this.billAmount = billAmount;
	}

	public String getBusinessField() {
		return this.businessField;
	}
	public void setBusinessField(String businessField) {
		this.businessField = businessField;
	}

	public String getCreateType() {
		return this.createType;
	}
	public void setCreateType(String createType) {
		this.createType = createType;
	}

	public String getFineAmount() {
		return this.fineAmount;
	}
	public void setFineAmount(String fineAmount) {
		this.fineAmount = fineAmount;
	}

	public String getInstCode() {
		return this.instCode;
	}
	public void setInstCode(String instCode) {
		this.instCode = instCode;
	}

	public String getInstPid() {
		return this.instPid;
	}
	public void setInstPid(String instPid) {
		this.instPid = instPid;
	}

	public String getItemId() {
		return this.itemId;
	}
	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOutNo() {
		return this.outNo;
	}
	public void setOutNo(String outNo) {
		this.outNo = outNo;
	}

	public PerFormTradeMap getOutTradeAssets() {
		return this.outTradeAssets;
	}
	public void setOutTradeAssets(PerFormTradeMap outTradeAssets) {
		this.outTradeAssets = outTradeAssets;
	}

	public List<ProfitSharingRequest> getProfitSharingList() {
		return this.profitSharingList;
	}
	public void setProfitSharingList(List<ProfitSharingRequest> profitSharingList) {
		this.profitSharingList = profitSharingList;
	}

	public String getScene() {
		return this.scene;
	}
	public void setScene(String scene) {
		this.scene = scene;
	}

	public String getServiceAccount() {
		return this.serviceAccount;
	}
	public void setServiceAccount(String serviceAccount) {
		this.serviceAccount = serviceAccount;
	}

	public String getServiceCode() {
		return this.serviceCode;
	}
	public void setServiceCode(String serviceCode) {
		this.serviceCode = serviceCode;
	}

	public String getThirdAmount() {
		return this.thirdAmount;
	}
	public void setThirdAmount(String thirdAmount) {
		this.thirdAmount = thirdAmount;
	}

	public Long getTimeoutChargeOff() {
		return this.timeoutChargeOff;
	}
	public void setTimeoutChargeOff(Long timeoutChargeOff) {
		this.timeoutChargeOff = timeoutChargeOff;
	}

	public Long getTimeoutClose() {
		return this.timeoutClose;
	}
	public void setTimeoutClose(Long timeoutClose) {
		this.timeoutClose = timeoutClose;
	}

	public String getUserName() {
		return this.userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}

}
