package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 银联C2B附加处理请求
 *
 * @author auto create
 * @since 1.0, 2022-03-12 22:28:43
 */
public class AlipayEbppIndustryGovUnionpaybsjsSyncModel extends AlipayObject {

	private static final long serialVersionUID = 2232731432497645758L;

	/**
	 * 证书id
	 */
	@ApiField("cert_id")
	private String certId;

	/**
	 * 交易币种
	 */
	@ApiField("currnecy_code")
	private String currnecyCode;

	/**
	 * c2b码
	 */
	@ApiField("qr_no")
	private String qrNo;

	/**
	 * 交易类型
	 */
	@ApiField("req_type")
	private String reqType;

	/**
	 * 交易附加信息（包含外部商户id，外部商户名称等）
	 */
	@ApiField("trans_add_info")
	private String transAddInfo;

	/**
	 * 交易金额
	 */
	@ApiField("txn_amt")
	private String txnAmt;

	/**
	 * 银联保留域
	 */
	@ApiField("up_reserverd")
	private String upReserverd;

	/**
	 * 付款凭证号（银联统一生成的交易索引）
	 */
	@ApiField("voucher_num")
	private String voucherNum;

	public String getCertId() {
		return this.certId;
	}
	public void setCertId(String certId) {
		this.certId = certId;
	}

	public String getCurrnecyCode() {
		return this.currnecyCode;
	}
	public void setCurrnecyCode(String currnecyCode) {
		this.currnecyCode = currnecyCode;
	}

	public String getQrNo() {
		return this.qrNo;
	}
	public void setQrNo(String qrNo) {
		this.qrNo = qrNo;
	}

	public String getReqType() {
		return this.reqType;
	}
	public void setReqType(String reqType) {
		this.reqType = reqType;
	}

	public String getTransAddInfo() {
		return this.transAddInfo;
	}
	public void setTransAddInfo(String transAddInfo) {
		this.transAddInfo = transAddInfo;
	}

	public String getTxnAmt() {
		return this.txnAmt;
	}
	public void setTxnAmt(String txnAmt) {
		this.txnAmt = txnAmt;
	}

	public String getUpReserverd() {
		return this.upReserverd;
	}
	public void setUpReserverd(String upReserverd) {
		this.upReserverd = upReserverd;
	}

	public String getVoucherNum() {
		return this.voucherNum;
	}
	public void setVoucherNum(String voucherNum) {
		this.voucherNum = voucherNum;
	}

}
