package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 公服行业通用业务信息查询
 *
 * @author auto create
 * @since 1.0, 2023-06-15 15:17:30
 */
public class AlipayEbppIndustryBizinfoQueryModel extends AlipayObject {

	private static final long serialVersionUID = 6861354869171682386L;

	/**
	 * 业务机构简称
	 */
	@ApiField("biz_inst")
	private String bizInst;

	/**
	 * 业务类型，公服业务：IND
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * 业务数据码，标识业务场景
	 */
	@ApiField("data_code")
	private String dataCode;

	/**
	 * 接口唯一标识
	 */
	@ApiField("interface_id")
	private String interfaceId;

	/**
	 * 链路的路由方式
	 */
	@ApiField("req_new_gw")
	private Boolean reqNewGw;

	/**
	 * 请求上下文，json格式
	 */
	@ApiField("request_context")
	private String requestContext;

	public String getBizInst() {
		return this.bizInst;
	}
	public void setBizInst(String bizInst) {
		this.bizInst = bizInst;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getDataCode() {
		return this.dataCode;
	}
	public void setDataCode(String dataCode) {
		this.dataCode = dataCode;
	}

	public String getInterfaceId() {
		return this.interfaceId;
	}
	public void setInterfaceId(String interfaceId) {
		this.interfaceId = interfaceId;
	}

	public Boolean getReqNewGw() {
		return this.reqNewGw;
	}
	public void setReqNewGw(Boolean reqNewGw) {
		this.reqNewGw = reqNewGw;
	}

	public String getRequestContext() {
		return this.requestContext;
	}
	public void setRequestContext(String requestContext) {
		this.requestContext = requestContext;
	}

}
