package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 将用户对策略结果的行为上报
 *
 * @author auto create
 * @since 1.0, 2023-06-14 16:53:09
 */
public class AlipayDataDataserviceSycmStrategybehaviorSyncModel extends AlipayObject {

	private static final long serialVersionUID = 5135978547978182316L;

	/**
	 * 行为类型：click（点击）、expose（曝光）、order（下单）、pay（支付）、collect（收藏）、like（点赞）、comment（评论）、share（分享）等
	 */
	@ApiField("action_type")
	private String actionType;

	/**
	 * 行为对应的物品列表,多个以逗号分隔
	 */
	@ApiField("item_id_list")
	private String itemIdList;

	/**
	 * 埋点上报时间戳、单位 ms
	 */
	@ApiField("log_time")
	private String logTime;

	/**
	 * 支付宝用户标识
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 推荐请求的traceid，用于关联推荐结果和用户行为
	 */
	@ApiField("trace_id")
	private String traceId;

	public String getActionType() {
		return this.actionType;
	}
	public void setActionType(String actionType) {
		this.actionType = actionType;
	}

	public String getItemIdList() {
		return this.itemIdList;
	}
	public void setItemIdList(String itemIdList) {
		this.itemIdList = itemIdList;
	}

	public String getLogTime() {
		return this.logTime;
	}
	public void setLogTime(String logTime) {
		this.logTime = logTime;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getTraceId() {
		return this.traceId;
	}
	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

}
