package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 批量上传创建或更新商品
 *
 * @author auto create
 * @since 1.0, 2023-07-06 17:25:26
 */
public class AlipayDataDataserviceAdProductCreateormodifyModel extends AlipayObject {

	private static final long serialVersionUID = 6354535367376856584L;

	/**
	 * 支付宝唯一id，标识商户
	 */
	@ApiField("alipay_pid")
	private String alipayPid;

	/**
	 * 灯火平台提供给外部系统的访问token
	 */
	@ApiField("biz_token")
	private String bizToken;

	/**
	 * 商品实体类型，由灯火分配code
	 */
	@ApiField("entity_type")
	private String entityType;

	/**
	 * 省份
	 */
	@ApiListField("product_list")
	@ApiField("product_entity")
	private List<ProductEntity> productList;

	/**
	 * 商品实体来源，code由灯火分配
	 */
	@ApiField("source")
	private String source;

	public String getAlipayPid() {
		return this.alipayPid;
	}
	public void setAlipayPid(String alipayPid) {
		this.alipayPid = alipayPid;
	}

	public String getBizToken() {
		return this.bizToken;
	}
	public void setBizToken(String bizToken) {
		this.bizToken = bizToken;
	}

	public String getEntityType() {
		return this.entityType;
	}
	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}

	public List<ProductEntity> getProductList() {
		return this.productList;
	}
	public void setProductList(List<ProductEntity> productList) {
		this.productList = productList;
	}

	public String getSource() {
		return this.source;
	}
	public void setSource(String source) {
		this.source = source;
	}

}
