package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 用户买水进度上报
 *
 * @author auto create
 * @since 1.0, 2023-07-12 14:21:48
 */
public class AlipayCommerceWaterUsertaskSendModel extends AlipayObject {

	private static final long serialVersionUID = 2679351257761199272L;

	/**
	 * 外部业务号，商家外部单号，同时用于幂等，同一个任务id，一个外部单号只能上报一次
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * 商户创建任务后生成的任务id
	 */
	@ApiField("task_id")
	private String taskId;

	/**
	 * 用户uid
	 */
	@ApiField("user_open_id")
	private String userOpenId;

	/**
	 * 用户参与任务生成的用户任务id
	 */
	@ApiField("user_task_id")
	private String userTaskId;

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public String getTaskId() {
		return this.taskId;
	}
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getUserOpenId() {
		return this.userOpenId;
	}
	public void setUserOpenId(String userOpenId) {
		this.userOpenId = userOpenId;
	}

	public String getUserTaskId() {
		return this.userTaskId;
	}
	public void setUserTaskId(String userTaskId) {
		this.userTaskId = userTaskId;
	}

}
