package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 出租车机具事件上送
 *
 * @author auto create
 * @since 1.0, 2021-06-11 17:57:00
 */
public class AlipayCommerceTransportTaxiMachineeventSendModel extends AlipayObject {

	private static final long serialVersionUID = 5181121554885699796L;

	/**
	 * 精度（实际类型为double，如5.0）
	 */
	@ApiField("accuracy")
	private String accuracy;

	/**
	 * KEY_FIRE_ON:钥匙点 KEY_FIRE_OFF钥匙门关
	 */
	@ApiField("car_key_status")
	private String carKeyStatus;

	/**
	 * 车牌号
	 */
	@ApiField("car_no")
	private String carNo;

	/**
	 * OPERATION_ON:营运 OPERATION_OFF停运
	 */
	@ApiField("car_operation_status")
	private String carOperationStatus;

	/**
	 * EMPTY:空车 NOT_EMPTY:重车
	 */
	@ApiField("car_status")
	private String carStatus;

	/**
	 * 车辆状态上传间隔，Unix Timestamp单位毫秒
	 */
	@ApiField("car_upload_interval")
	private String carUploadInterval;

	/**
	 * 支付宝给ISV分配的渠道号
	 */
	@ApiField("channel")
	private String channel;

	/**
	 * 实际类型为double，如335.039
	 */
	@ApiField("direction")
	private String direction;

	/**
	 * 调度费，单位分
	 */
	@ApiField("dispatch_amount")
	private String dispatchAmount;

	/**
	 * 事件类型，包含压表，抬表，车辆GPS上传等多个事件，详情请见附属的excel文件。
	 */
	@ApiField("event")
	private String event;

	/**
	 * 扩展信息
	 */
	@ApiField("extend_info")
	private String extendInfo;

	/**
	 * GPS上传间隔，Unix Timestamp单位毫秒
	 */
	@ApiField("gps_upload_interval")
	private String gpsUploadInterval;

	/**
	 * 海拔高度，单位米
	 */
	@ApiField("height")
	private String height;

	/**
	 * 纬度
	 */
	@ApiField("latitude")
	private String latitude;

	/**
	 * LOCATE:定位 NOT_LOCATE未定位
	 */
	@ApiField("locate_status")
	private String locateStatus;

	/**
	 * 定位事件，Unix Timestamp单位毫秒
	 */
	@ApiField("locate_time")
	private String locateTime;

	/**
	 * 经度
	 */
	@ApiField("longitude")
	private String longitude;

	/**
	 * 低速等候时间（Unix Timestamp单位毫秒）
	 */
	@ApiField("lowspeed_wait_time")
	private String lowspeedWaitTime;

	/**
	 * 设备标识符
	 */
	@ApiField("machine_sn")
	private String machineSn;

	/**
	 * 说明信息
	 */
	@ApiField("memo")
	private String memo;

	/**
	 * 燃油附加费（单位分）
	 */
	@ApiField("oil_amount")
	private String oilAmount;

	/**
	 * 计价器总金额，单位分
	 */
	@ApiField("order_amount")
	private String orderAmount;

	/**
	 * 订单时长（Unix Timestamp单位毫秒）
	 */
	@ApiField("order_cost_time")
	private String orderCostTime;

	/**
	 * 订单ID
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 订单类型
	 */
	@ApiField("order_type")
	private String orderType;

	/**
	 * 计价器状态 NORMAL:正常 FAIL:故障
	 */
	@ApiField("price_machine_status")
	private String priceMachineStatus;

	/**
	 * 请求时间
	 */
	@ApiField("request_time")
	private String requestTime;

	/**
	 * 速度（实际类型为double）
	 */
	@ApiField("speed")
	private String speed;

	/**
	 * 计价器行程费 单位分
	 */
	@ApiField("trip_amount")
	private String tripAmount;

	/**
	 * 行程结束时间（Unix Timestamp单位毫秒）
	 */
	@ApiField("trip_end_time")
	private String tripEndTime;

	/**
	 * 订单实际里程（单位：米）
	 */
	@ApiField("trip_mileage")
	private String tripMileage;

	/**
	 * 行程开始时间，Unix Timestamp单位毫秒
	 */
	@ApiField("trip_start_time")
	private String tripStartTime;

	/**
	 * 写入状态（ 1：写入成功 0：写入失败）
	 */
	@ApiField("write_status")
	private String writeStatus;

	public String getAccuracy() {
		return this.accuracy;
	}
	public void setAccuracy(String accuracy) {
		this.accuracy = accuracy;
	}

	public String getCarKeyStatus() {
		return this.carKeyStatus;
	}
	public void setCarKeyStatus(String carKeyStatus) {
		this.carKeyStatus = carKeyStatus;
	}

	public String getCarNo() {
		return this.carNo;
	}
	public void setCarNo(String carNo) {
		this.carNo = carNo;
	}

	public String getCarOperationStatus() {
		return this.carOperationStatus;
	}
	public void setCarOperationStatus(String carOperationStatus) {
		this.carOperationStatus = carOperationStatus;
	}

	public String getCarStatus() {
		return this.carStatus;
	}
	public void setCarStatus(String carStatus) {
		this.carStatus = carStatus;
	}

	public String getCarUploadInterval() {
		return this.carUploadInterval;
	}
	public void setCarUploadInterval(String carUploadInterval) {
		this.carUploadInterval = carUploadInterval;
	}

	public String getChannel() {
		return this.channel;
	}
	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getDirection() {
		return this.direction;
	}
	public void setDirection(String direction) {
		this.direction = direction;
	}

	public String getDispatchAmount() {
		return this.dispatchAmount;
	}
	public void setDispatchAmount(String dispatchAmount) {
		this.dispatchAmount = dispatchAmount;
	}

	public String getEvent() {
		return this.event;
	}
	public void setEvent(String event) {
		this.event = event;
	}

	public String getExtendInfo() {
		return this.extendInfo;
	}
	public void setExtendInfo(String extendInfo) {
		this.extendInfo = extendInfo;
	}

	public String getGpsUploadInterval() {
		return this.gpsUploadInterval;
	}
	public void setGpsUploadInterval(String gpsUploadInterval) {
		this.gpsUploadInterval = gpsUploadInterval;
	}

	public String getHeight() {
		return this.height;
	}
	public void setHeight(String height) {
		this.height = height;
	}

	public String getLatitude() {
		return this.latitude;
	}
	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLocateStatus() {
		return this.locateStatus;
	}
	public void setLocateStatus(String locateStatus) {
		this.locateStatus = locateStatus;
	}

	public String getLocateTime() {
		return this.locateTime;
	}
	public void setLocateTime(String locateTime) {
		this.locateTime = locateTime;
	}

	public String getLongitude() {
		return this.longitude;
	}
	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLowspeedWaitTime() {
		return this.lowspeedWaitTime;
	}
	public void setLowspeedWaitTime(String lowspeedWaitTime) {
		this.lowspeedWaitTime = lowspeedWaitTime;
	}

	public String getMachineSn() {
		return this.machineSn;
	}
	public void setMachineSn(String machineSn) {
		this.machineSn = machineSn;
	}

	public String getMemo() {
		return this.memo;
	}
	public void setMemo(String memo) {
		this.memo = memo;
	}

	public String getOilAmount() {
		return this.oilAmount;
	}
	public void setOilAmount(String oilAmount) {
		this.oilAmount = oilAmount;
	}

	public String getOrderAmount() {
		return this.orderAmount;
	}
	public void setOrderAmount(String orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getOrderCostTime() {
		return this.orderCostTime;
	}
	public void setOrderCostTime(String orderCostTime) {
		this.orderCostTime = orderCostTime;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderType() {
		return this.orderType;
	}
	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	public String getPriceMachineStatus() {
		return this.priceMachineStatus;
	}
	public void setPriceMachineStatus(String priceMachineStatus) {
		this.priceMachineStatus = priceMachineStatus;
	}

	public String getRequestTime() {
		return this.requestTime;
	}
	public void setRequestTime(String requestTime) {
		this.requestTime = requestTime;
	}

	public String getSpeed() {
		return this.speed;
	}
	public void setSpeed(String speed) {
		this.speed = speed;
	}

	public String getTripAmount() {
		return this.tripAmount;
	}
	public void setTripAmount(String tripAmount) {
		this.tripAmount = tripAmount;
	}

	public String getTripEndTime() {
		return this.tripEndTime;
	}
	public void setTripEndTime(String tripEndTime) {
		this.tripEndTime = tripEndTime;
	}

	public String getTripMileage() {
		return this.tripMileage;
	}
	public void setTripMileage(String tripMileage) {
		this.tripMileage = tripMileage;
	}

	public String getTripStartTime() {
		return this.tripStartTime;
	}
	public void setTripStartTime(String tripStartTime) {
		this.tripStartTime = tripStartTime;
	}

	public String getWriteStatus() {
		return this.writeStatus;
	}
	public void setWriteStatus(String writeStatus) {
		this.writeStatus = writeStatus;
	}

}
