package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 联营-一站式发布
 *
 * @author auto create
 * @since 1.0, 2023-06-13 10:55:14
 */
public class AlipayCommerceOperationPlanOnestopSubmitModel extends AlipayObject {

	private static final long serialVersionUID = 3697518924762671773L;

	/**
	 * 计划介绍信息
	 */
	@ApiField("intro")
	private BsBrandPlanIntro intro;

	/**
	 * 外部业务号
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * 参与者列表
	 */
	@ApiListField("participants")
	@ApiField("bs_participant_d_t_o")
	private List<BsParticipantDTO> participants;

	/**
	 * 常量，方案编码，跟对接人沟通
	 */
	@ApiField("solution_code")
	private String solutionCode;

	/**
	 * v邦洞供给
	 */
	@ApiListField("supplies")
	@ApiField("bs_plan_supply_item")
	private List<BsPlanSupplyItem> supplies;

	public BsBrandPlanIntro getIntro() {
		return this.intro;
	}
	public void setIntro(BsBrandPlanIntro intro) {
		this.intro = intro;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public List<BsParticipantDTO> getParticipants() {
		return this.participants;
	}
	public void setParticipants(List<BsParticipantDTO> participants) {
		this.participants = participants;
	}

	public String getSolutionCode() {
		return this.solutionCode;
	}
	public void setSolutionCode(String solutionCode) {
		this.solutionCode = solutionCode;
	}

	public List<BsPlanSupplyItem> getSupplies() {
		return this.supplies;
	}
	public void setSupplies(List<BsPlanSupplyItem> supplies) {
		this.supplies = supplies;
	}

}
