package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 确认生态协同单接口
 *
 * @author auto create
 * @since 1.0, 2020-03-19 16:14:30
 */
public class AlipayCommerceFixTaskConfirmModel extends AlipayObject {

	private static final long serialVersionUID = 7837474482152682318L;

	/**
	 * 反馈文字内容
	 */
	@ApiField("feedback")
	private String feedback;

	/**
	 * 问题是否解决。枚举：yes:已解决;no:未解决
	 */
	@ApiField("is_resolved")
	private String isResolved;

	/**
	 * 完成确认人员的支付宝pid
	 */
	@ApiField("operator")
	private String operator;

	/**
	 * 评分，范围：0到5星。
	 */
	@ApiField("rating")
	private Long rating;

	/**
	 * 要确认工单的id
	 */
	@ApiField("task_id")
	private Long taskId;

	/**
	 * 问题未解决的原因。值从未解决原因列表接口中查询获取
	 */
	@ApiField("unresolved_reason")
	private String unresolvedReason;

	public String getFeedback() {
		return this.feedback;
	}
	public void setFeedback(String feedback) {
		this.feedback = feedback;
	}

	public String getIsResolved() {
		return this.isResolved;
	}
	public void setIsResolved(String isResolved) {
		this.isResolved = isResolved;
	}

	public String getOperator() {
		return this.operator;
	}
	public void setOperator(String operator) {
		this.operator = operator;
	}

	public Long getRating() {
		return this.rating;
	}
	public void setRating(Long rating) {
		this.rating = rating;
	}

	public Long getTaskId() {
		return this.taskId;
	}
	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}

	public String getUnresolvedReason() {
		return this.unresolvedReason;
	}
	public void setUnresolvedReason(String unresolvedReason) {
		this.unresolvedReason = unresolvedReason;
	}

}
