package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 成长派订单消息发送
 *
 * @author auto create
 * @since 1.0, 2023-06-21 16:32:03
 */
public class AlipayCommerceEducateYouthOrdermessageSendModel extends AlipayObject {

	private static final long serialVersionUID = 4243258256841861423L;

	/**
	 * 用于区分不同业务类型
	 */
	@ApiField("biz_code")
	private String bizCode;

	/**
	 * 经营单元信息
	 */
	@ApiField("biz_unit_info")
	private OrderBizUnitInfo bizUnitInfo;

	/**
	 * 创建时间，格式：yyyy-MM-dd HH:mm:ss
	 */
	@ApiField("create_time")
	private String createTime;

	/**
	 * 优惠金额，单位：元
	 */
	@ApiField("discount_amount")
	private String discountAmount;

	/**
	 * 消息发送者AppId
	 */
	@ApiField("from_app_id")
	private String fromAppId;

	/**
	 * 商品列表
	 */
	@ApiListField("goods")
	@ApiField("order_good")
	private List<OrderGood> goods;

	/**
	 * 扩展信息
	 */
	@ApiField("message_properties")
	private String messageProperties;

	/**
	 * 修改时间，时间格式：yyyy-MM-dd HH:mm:ss.SSS
	 */
	@ApiField("modified_time")
	private String modifiedTime;

	/**
	 * 消息枚举
	 */
	@ApiField("msg_enum")
	private String msgEnum;

	/**
	 * 消息接收者openId
	 */
	@ApiField("open_id")
	private String openId;

	/**
	 * 订单金额，单位：元
	 */
	@ApiField("order_amount")
	private String orderAmount;

	/**
	 * 订单详情的小程序跳转页面
	 */
	@ApiField("order_detail_page_path")
	private String orderDetailPagePath;

	/**
	 * 订单状态
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 外部交易号，保证唯一性
	 */
	@ApiField("out_order_no")
	private String outOrderNo;

	/**
	 * 交易订单列表
	 */
	@ApiListField("payment_orders")
	@ApiField("payment_order_info")
	private List<PaymentOrderInfo> paymentOrders;

	/**
	 * 订单收款方PID
	 */
	@ApiField("pid")
	private String pid;

	/**
	 * 实际金额，单位：元
	 */
	@ApiField("real_amount")
	private String realAmount;

	/**
	 * 消息接收者UID(即买家UID)
	 */
	@ApiField("to_user_id")
	private String toUserId;

	public String getBizCode() {
		return this.bizCode;
	}
	public void setBizCode(String bizCode) {
		this.bizCode = bizCode;
	}

	public OrderBizUnitInfo getBizUnitInfo() {
		return this.bizUnitInfo;
	}
	public void setBizUnitInfo(OrderBizUnitInfo bizUnitInfo) {
		this.bizUnitInfo = bizUnitInfo;
	}

	public String getCreateTime() {
		return this.createTime;
	}
	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public String getDiscountAmount() {
		return this.discountAmount;
	}
	public void setDiscountAmount(String discountAmount) {
		this.discountAmount = discountAmount;
	}

	public String getFromAppId() {
		return this.fromAppId;
	}
	public void setFromAppId(String fromAppId) {
		this.fromAppId = fromAppId;
	}

	public List<OrderGood> getGoods() {
		return this.goods;
	}
	public void setGoods(List<OrderGood> goods) {
		this.goods = goods;
	}

	public String getMessageProperties() {
		return this.messageProperties;
	}
	public void setMessageProperties(String messageProperties) {
		this.messageProperties = messageProperties;
	}

	public String getModifiedTime() {
		return this.modifiedTime;
	}
	public void setModifiedTime(String modifiedTime) {
		this.modifiedTime = modifiedTime;
	}

	public String getMsgEnum() {
		return this.msgEnum;
	}
	public void setMsgEnum(String msgEnum) {
		this.msgEnum = msgEnum;
	}

	public String getOpenId() {
		return this.openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOrderAmount() {
		return this.orderAmount;
	}
	public void setOrderAmount(String orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getOrderDetailPagePath() {
		return this.orderDetailPagePath;
	}
	public void setOrderDetailPagePath(String orderDetailPagePath) {
		this.orderDetailPagePath = orderDetailPagePath;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOutOrderNo() {
		return this.outOrderNo;
	}
	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}

	public List<PaymentOrderInfo> getPaymentOrders() {
		return this.paymentOrders;
	}
	public void setPaymentOrders(List<PaymentOrderInfo> paymentOrders) {
		this.paymentOrders = paymentOrders;
	}

	public String getPid() {
		return this.pid;
	}
	public void setPid(String pid) {
		this.pid = pid;
	}

	public String getRealAmount() {
		return this.realAmount;
	}
	public void setRealAmount(String realAmount) {
		this.realAmount = realAmount;
	}

	public String getToUserId() {
		return this.toUserId;
	}
	public void setToUserId(String toUserId) {
		this.toUserId = toUserId;
	}

}
