package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 一脸通行学生银行卡绑定并设置为支付顺序首位
 *
 * @author auto create
 * @since 1.0, 2023-06-12 14:51:21
 */
public class AlipayCommerceEducateUserCardBindModel extends AlipayObject {

	private static final long serialVersionUID = 6884596156117628528L;

	/**
	 * 银行名称
	 */
	@ApiField("bank_name")
	private String bankName;

	/**
	 * 银行卡号
	 */
	@ApiField("card_no")
	private String cardNo;

	/**
	 * 证件号
	 */
	@ApiField("cert_no")
	private String certNo;

	/**
	 * 证件类型，身份证类型：IDENTITY_CARD
	 */
	@ApiField("cert_type")
	private String certType;

	/**
	 * 联系手机号
	 */
	@ApiField("contact_mobile")
	private String contactMobile;

	/**
	 * 联行号
	 */
	@ApiField("deposit_bank_cnaps_code")
	private String depositBankCnapsCode;

	/**
	 * 姓名
	 */
	@ApiField("user_name")
	private String userName;

	public String getBankName() {
		return this.bankName;
	}
	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getCardNo() {
		return this.cardNo;
	}
	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getCertNo() {
		return this.certNo;
	}
	public void setCertNo(String certNo) {
		this.certNo = certNo;
	}

	public String getCertType() {
		return this.certType;
	}
	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getContactMobile() {
		return this.contactMobile;
	}
	public void setContactMobile(String contactMobile) {
		this.contactMobile = contactMobile;
	}

	public String getDepositBankCnapsCode() {
		return this.depositBankCnapsCode;
	}
	public void setDepositBankCnapsCode(String depositBankCnapsCode) {
		this.depositBankCnapsCode = depositBankCnapsCode;
	}

	public String getUserName() {
		return this.userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}

}
