package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 酒店服务上报
 *
 * @author auto create
 * @since 1.0, 2023-04-14 15:12:30
 */
public class AlipayBusinessItemServiceHotelSyncModel extends AlipayObject {

	private static final long serialVersionUID = 6412911144954753725L;

	/**
	 * 酒店品牌名称
	 */
	@ApiField("brand_name")
	private String brandName;

	/**
	 * 扩展信息
	 */
	@ApiField("ext_info")
	private ScenicExtInfo extInfo;

	/**
	 * 酒店地址
	 */
	@ApiField("hotel_address")
	private String hotelAddress;

	/**
	 * 酒店小程序id
	 */
	@ApiField("hotel_app_id")
	private String hotelAppId;

	/**
	 * 酒店名称
	 */
	@ApiField("hotel_name")
	private String hotelName;

	/**
	 * 酒店纬度
	 */
	@ApiField("latitude")
	private String latitude;

	/**
	 * 酒店经度
	 */
	@ApiField("longitude")
	private String longitude;

	/**
	 * 商户侧酒店id
	 */
	@ApiField("outer_hotel_id")
	private String outerHotelId;

	/**
	 * 商户id
	 */
	@ApiField("pid")
	private String pid;

	/**
	 * 服务描述
	 */
	@ApiField("service_description")
	private String serviceDescription;

	/**
	 * 服务名称
	 */
	@ApiField("service_name")
	private String serviceName;

	/**
	 * 服务类型
	 */
	@ApiField("service_type")
	private String serviceType;

	/**
	 * 服务URL
	 */
	@ApiField("service_url")
	private String serviceUrl;

	/**
	 * 酒店联系电话
	 */
	@ApiField("telephone")
	private String telephone;

	public String getBrandName() {
		return this.brandName;
	}
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}

	public ScenicExtInfo getExtInfo() {
		return this.extInfo;
	}
	public void setExtInfo(ScenicExtInfo extInfo) {
		this.extInfo = extInfo;
	}

	public String getHotelAddress() {
		return this.hotelAddress;
	}
	public void setHotelAddress(String hotelAddress) {
		this.hotelAddress = hotelAddress;
	}

	public String getHotelAppId() {
		return this.hotelAppId;
	}
	public void setHotelAppId(String hotelAppId) {
		this.hotelAppId = hotelAppId;
	}

	public String getHotelName() {
		return this.hotelName;
	}
	public void setHotelName(String hotelName) {
		this.hotelName = hotelName;
	}

	public String getLatitude() {
		return this.latitude;
	}
	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLongitude() {
		return this.longitude;
	}
	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getOuterHotelId() {
		return this.outerHotelId;
	}
	public void setOuterHotelId(String outerHotelId) {
		this.outerHotelId = outerHotelId;
	}

	public String getPid() {
		return this.pid;
	}
	public void setPid(String pid) {
		this.pid = pid;
	}

	public String getServiceDescription() {
		return this.serviceDescription;
	}
	public void setServiceDescription(String serviceDescription) {
		this.serviceDescription = serviceDescription;
	}

	public String getServiceName() {
		return this.serviceName;
	}
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public String getServiceType() {
		return this.serviceType;
	}
	public void setServiceType(String serviceType) {
		this.serviceType = serviceType;
	}

	public String getServiceUrl() {
		return this.serviceUrl;
	}
	public void setServiceUrl(String serviceUrl) {
		this.serviceUrl = serviceUrl;
	}

	public String getTelephone() {
		return this.telephone;
	}
	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

}
