package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 双方电子CA签署业务签署方注册信息查询接口
 *
 * @author auto create
 * @since 1.0, 2022-05-31 15:15:13
 */
public class AlipayBossProdCasignSignerQueryModel extends AlipayObject {

	private static final long serialVersionUID = 1189382898346229671L;

	/**
	 * 业务来源系统
	 */
	@ApiField("app_name")
	private String appName;

	/**
	 * 业务线
	 */
	@ApiField("business_line_code")
	private String businessLineCode;

	/**
	 * 场景值code
	 */
	@ApiField("scene_code")
	private String sceneCode;

	/**
	 * 用户ID，由业务系统提供，与证件号至少填一个
	 */
	@ApiField("sign_user_id")
	private String signUserId;

	/**
	 * 租户信息
	 */
	@ApiField("tenant")
	private String tenant;

	/**
	 * 用户证件号id，与用户ID至少填一个
	 */
	@ApiField("user_cert_number")
	private String userCertNumber;

	public String getAppName() {
		return this.appName;
	}
	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getBusinessLineCode() {
		return this.businessLineCode;
	}
	public void setBusinessLineCode(String businessLineCode) {
		this.businessLineCode = businessLineCode;
	}

	public String getSceneCode() {
		return this.sceneCode;
	}
	public void setSceneCode(String sceneCode) {
		this.sceneCode = sceneCode;
	}

	public String getSignUserId() {
		return this.signUserId;
	}
	public void setSignUserId(String signUserId) {
		this.signUserId = signUserId;
	}

	public String getTenant() {
		return this.tenant;
	}
	public void setTenant(String tenant) {
		this.tenant = tenant;
	}

	public String getUserCertNumber() {
		return this.userCertNumber;
	}
	public void setUserCertNumber(String userCertNumber) {
		this.userCertNumber = userCertNumber;
	}

}
