package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 签署中心 - 发起签署请求
 *
 * @author auto create
 * @since 1.0, 2023-03-28 14:10:21
 */
public class AlipayBossProdAlsacenterSignApplyModel extends AlipayObject {

	private static final long serialVersionUID = 4775676457274411358L;

	/**
	 * 文件用印列表（仅用于单方ca且必选）
	 */
	@ApiListField("aes_seal_list")
	@ApiField("alsacenter_aes_seal_d_t_o")
	private List<AlsacenterAesSealDTO> aesSealList;

	/**
	 * 蚂蚁电子签（仅用于蚂蚁电子签且必选）
	 */
	@ApiField("ant_sign_dto")
	private AlsacenterAntSignDTO antSignDto;

	/**
	 * 调用方appCode
	 */
	@ApiField("app_code")
	private String appCode;

	/**
	 * 来源应用
	 */
	@ApiField("app_name")
	private String appName;

	/**
	 * 附件信息集合
	 */
	@ApiListField("attachment_files_list")
	@ApiField("alsacenter_attachment_file_d_t_o")
	private List<AlsacenterAttachmentFileDTO> attachmentFilesList;

	/**
	 * 用印描述
	 */
	@ApiField("biz_description")
	private String bizDescription;

	/**
	 * 合同名称
必选：1纸质用印;3BlockChain;4蚂蚁电子签;5单方ca;6电子打印章;
可选：2Docusign;
	 */
	@ApiField("biz_name")
	private String bizName;

	/**
	 * 区块链签约对象（仅用于区块链BlockChain且必选）
	 */
	@ApiField("block_chain_dto")
	private AlsacenterBlockChainDTO blockChainDto;

	/**
	 * 业务单据号
	 */
	@ApiField("business_id")
	private String businessId;

	/**
	 * 业务线
	 */
	@ApiField("business_line_code")
	private String businessLineCode;

	/**
	 * 回调地址
必选：4蚂蚁电子签;
可选：1纸质用印;2Docusign;3BlockChain;5单方ca;6电子打印章;
	 */
	@ApiField("callback_url")
	private String callbackUrl;

	/**
	 * Docusign对象（仅用于Docusign且必选）
	 */
	@ApiField("docusign_dto")
	private AlsacenterDocusignDTO docusignDto;

	/**
	 * 电子打印章（仅用于电子打印章且必选）
	 */
	@ApiField("elec_print_seal_dto")
	private AlsacenterElecPrintSealDTO elecPrintSealDto;

	/**
	 * 操作人工号
	 */
	@ApiField("emp_id")
	private String empId;

	/**
	 * 操作人花名
	 */
	@ApiField("emp_nick_name")
	private String empNickName;

	/**
	 * 操作人真名
	 */
	@ApiField("emp_real_name")
	private String empRealName;

	/**
	 * 操作人信息
必选：2Docusign;4蚂蚁电子签;
可选：1纸质用印;3BlockChain;5单方ca;6电子打印章;
	 */
	@ApiField("operator_dto")
	private AlsacenterOperatorDTO operatorDto;

	/**
	 * 他方签署实体列表
必选：1纸质用印;
可选：2Docusign;3BlockChain;4蚂蚁电子签;5单方ca;6电子打印章;
	 */
	@ApiListField("other_sign_operator_list")
	@ApiField("alsacenter_sign_operator_d_t_o")
	private List<AlsacenterSignOperatorDTO> otherSignOperatorList;

	/**
	 * 我方签署实体列表
	 */
	@ApiListField("our_sign_operator_list")
	@ApiField("alsacenter_sign_operator_d_t_o")
	private List<AlsacenterSignOperatorDTO> ourSignOperatorList;

	/**
	 * 归属人信息
必选：3BlockChain;4蚂蚁电子签;6电子打印章;
可选：1纸质用印;2Docusign;5单方ca;
	 */
	@ApiField("ownership_dto")
	private AlsacenterOperatorDTO ownershipDto;

	/**
	 * 纸质用印（仅用于纸质用印且必选）
	 */
	@ApiField("paper_seal_dto")
	private AlsacenterPaperSealDTO paperSealDto;

	/**
	 * 流程信息
	 */
	@ApiField("process_dto")
	private AlsacenterProcessDTO processDto;

	/**
	 * 场景值
	 */
	@ApiField("scene_code")
	private String sceneCode;

	/**
	 * 用印时展示给法务的信息列表
必选：1纸质用印;
可选：2Docusign;3BlockChain;4蚂蚁电子签;5单方ca;6电子打印章;
	 */
	@ApiListField("seal_display_dtos_list")
	@ApiField("alsacenter_seal_display_d_t_o")
	private List<AlsacenterSealDisplayDTO> sealDisplayDtosList;

	/**
	 * 签署文件类型  CONTRACT("CONTRACT", "合同"), FILE("FILE", "文件")
必选：1纸质用印;4蚂蚁电子签;5单方ca;
可选：2Docusign;3BlockChain;6电子打印章;
	 */
	@ApiField("seal_file_type")
	private String sealFileType;

	/**
	 * 保密等级 0 - 默认 1 - 中级 2 - 高级
	 */
	@ApiField("secret_level")
	private Long secretLevel;

	/**
	 * 签署类型
	 */
	@ApiField("sign_method")
	private String signMethod;

	/**
	 * 需要签署的文件列表
必选：2Docusign;3BlockChain;6电子打印章;
可选：1纸质用印;4蚂蚁电子签;5单方ca;
	 */
	@ApiListField("sign_task_files_list")
	@ApiField("alsacenter_attachment_file_d_t_o")
	private List<AlsacenterAttachmentFileDTO> signTaskFilesList;

	/**
	 * 系统来源id
	 */
	@ApiField("source_system_id")
	private String sourceSystemId;

	/**
	 * 系统来源地址
	 */
	@ApiField("source_url")
	private String sourceUrl;

	/**
	 * 子单号
必选：2Docusign;5单方ca;
可选：1纸质用印;3BlockChain;4蚂蚁电子签;6电子打印章;
	 */
	@ApiField("sub_business_id")
	private String subBusinessId;

	/**
	 * 租户信息
	 */
	@ApiField("tenant")
	private String tenant;

	public List<AlsacenterAesSealDTO> getAesSealList() {
		return this.aesSealList;
	}
	public void setAesSealList(List<AlsacenterAesSealDTO> aesSealList) {
		this.aesSealList = aesSealList;
	}

	public AlsacenterAntSignDTO getAntSignDto() {
		return this.antSignDto;
	}
	public void setAntSignDto(AlsacenterAntSignDTO antSignDto) {
		this.antSignDto = antSignDto;
	}

	public String getAppCode() {
		return this.appCode;
	}
	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}

	public String getAppName() {
		return this.appName;
	}
	public void setAppName(String appName) {
		this.appName = appName;
	}

	public List<AlsacenterAttachmentFileDTO> getAttachmentFilesList() {
		return this.attachmentFilesList;
	}
	public void setAttachmentFilesList(List<AlsacenterAttachmentFileDTO> attachmentFilesList) {
		this.attachmentFilesList = attachmentFilesList;
	}

	public String getBizDescription() {
		return this.bizDescription;
	}
	public void setBizDescription(String bizDescription) {
		this.bizDescription = bizDescription;
	}

	public String getBizName() {
		return this.bizName;
	}
	public void setBizName(String bizName) {
		this.bizName = bizName;
	}

	public AlsacenterBlockChainDTO getBlockChainDto() {
		return this.blockChainDto;
	}
	public void setBlockChainDto(AlsacenterBlockChainDTO blockChainDto) {
		this.blockChainDto = blockChainDto;
	}

	public String getBusinessId() {
		return this.businessId;
	}
	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getBusinessLineCode() {
		return this.businessLineCode;
	}
	public void setBusinessLineCode(String businessLineCode) {
		this.businessLineCode = businessLineCode;
	}

	public String getCallbackUrl() {
		return this.callbackUrl;
	}
	public void setCallbackUrl(String callbackUrl) {
		this.callbackUrl = callbackUrl;
	}

	public AlsacenterDocusignDTO getDocusignDto() {
		return this.docusignDto;
	}
	public void setDocusignDto(AlsacenterDocusignDTO docusignDto) {
		this.docusignDto = docusignDto;
	}

	public AlsacenterElecPrintSealDTO getElecPrintSealDto() {
		return this.elecPrintSealDto;
	}
	public void setElecPrintSealDto(AlsacenterElecPrintSealDTO elecPrintSealDto) {
		this.elecPrintSealDto = elecPrintSealDto;
	}

	public String getEmpId() {
		return this.empId;
	}
	public void setEmpId(String empId) {
		this.empId = empId;
	}

	public String getEmpNickName() {
		return this.empNickName;
	}
	public void setEmpNickName(String empNickName) {
		this.empNickName = empNickName;
	}

	public String getEmpRealName() {
		return this.empRealName;
	}
	public void setEmpRealName(String empRealName) {
		this.empRealName = empRealName;
	}

	public AlsacenterOperatorDTO getOperatorDto() {
		return this.operatorDto;
	}
	public void setOperatorDto(AlsacenterOperatorDTO operatorDto) {
		this.operatorDto = operatorDto;
	}

	public List<AlsacenterSignOperatorDTO> getOtherSignOperatorList() {
		return this.otherSignOperatorList;
	}
	public void setOtherSignOperatorList(List<AlsacenterSignOperatorDTO> otherSignOperatorList) {
		this.otherSignOperatorList = otherSignOperatorList;
	}

	public List<AlsacenterSignOperatorDTO> getOurSignOperatorList() {
		return this.ourSignOperatorList;
	}
	public void setOurSignOperatorList(List<AlsacenterSignOperatorDTO> ourSignOperatorList) {
		this.ourSignOperatorList = ourSignOperatorList;
	}

	public AlsacenterOperatorDTO getOwnershipDto() {
		return this.ownershipDto;
	}
	public void setOwnershipDto(AlsacenterOperatorDTO ownershipDto) {
		this.ownershipDto = ownershipDto;
	}

	public AlsacenterPaperSealDTO getPaperSealDto() {
		return this.paperSealDto;
	}
	public void setPaperSealDto(AlsacenterPaperSealDTO paperSealDto) {
		this.paperSealDto = paperSealDto;
	}

	public AlsacenterProcessDTO getProcessDto() {
		return this.processDto;
	}
	public void setProcessDto(AlsacenterProcessDTO processDto) {
		this.processDto = processDto;
	}

	public String getSceneCode() {
		return this.sceneCode;
	}
	public void setSceneCode(String sceneCode) {
		this.sceneCode = sceneCode;
	}

	public List<AlsacenterSealDisplayDTO> getSealDisplayDtosList() {
		return this.sealDisplayDtosList;
	}
	public void setSealDisplayDtosList(List<AlsacenterSealDisplayDTO> sealDisplayDtosList) {
		this.sealDisplayDtosList = sealDisplayDtosList;
	}

	public String getSealFileType() {
		return this.sealFileType;
	}
	public void setSealFileType(String sealFileType) {
		this.sealFileType = sealFileType;
	}

	public Long getSecretLevel() {
		return this.secretLevel;
	}
	public void setSecretLevel(Long secretLevel) {
		this.secretLevel = secretLevel;
	}

	public String getSignMethod() {
		return this.signMethod;
	}
	public void setSignMethod(String signMethod) {
		this.signMethod = signMethod;
	}

	public List<AlsacenterAttachmentFileDTO> getSignTaskFilesList() {
		return this.signTaskFilesList;
	}
	public void setSignTaskFilesList(List<AlsacenterAttachmentFileDTO> signTaskFilesList) {
		this.signTaskFilesList = signTaskFilesList;
	}

	public String getSourceSystemId() {
		return this.sourceSystemId;
	}
	public void setSourceSystemId(String sourceSystemId) {
		this.sourceSystemId = sourceSystemId;
	}

	public String getSourceUrl() {
		return this.sourceUrl;
	}
	public void setSourceUrl(String sourceUrl) {
		this.sourceUrl = sourceUrl;
	}

	public String getSubBusinessId() {
		return this.subBusinessId;
	}
	public void setSubBusinessId(String subBusinessId) {
		this.subBusinessId = subBusinessId;
	}

	public String getTenant() {
		return this.tenant;
	}
	public void setTenant(String tenant) {
		this.tenant = tenant;
	}

}
