package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 创建财务单据
 *
 * @author auto create
 * @since 1.0, 2019-12-24 16:00:37
 */
public class AlipayBossFncArbillCreateModel extends AlipayObject {

	private static final long serialVersionUID = 4627216653919978789L;

	/**
	 * 透传的核算维度
	 */
	@ApiField("account_dmsn")
	private Map accountDmsn;

	/**
	 * 合约号
	 */
	@ApiField("agreement_no")
	private String agreementNo;

	/**
	 * 合约来源
iarcore：ipay合约中心
mybkarcore：网商合约中心
arcore：主站合约中心
other：其他合约
	 */
	@ApiField("agreement_source")
	private String agreementSource;

	/**
	 * 账单金额
	 */
	@ApiField("bill_amt")
	private MultiCurrencyMoneyOpenApi billAmt;

	/**
	 * 业务时间
	 */
	@ApiField("bill_date")
	private Date billDate;

	/**
	 * 业务单据号，上游保证唯一性（用于幂等）
	 */
	@ApiField("biz_no")
	private String bizNo;

	/**
	 * 收费项编码
	 */
	@ApiField("charge_item_code")
	private String chargeItemCode;

	/**
	 * 对应的结算单，对应收费请求的时候的唯一id
在智航中，对应361区分一个收款请求的id
	 */
	@ApiField("charge_order_no")
	private String chargeOrderNo;

	/**
	 * 计费服务量
	 */
	@ApiField("clcn_basic_amt")
	private Long clcnBasicAmt;

	/**
	 * 计费服务类型
05（其他）
	 */
	@ApiField("clcn_basic_type")
	private String clcnBasicType;

	/**
	 * 透传的扩展信息
	 */
	@ApiField("exn_info")
	private Map exnInfo;

	/**
	 * 资金凭证号（对于业务上游感知收款的情况，传入字段。用户关联资金流水）
	 */
	@ApiField("fund_voucher_no")
	private String fundVoucherNo;

	/**
	 * 所属ou
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 对应商户的mid（签约成为我们商户时，mif系统分配）
	 */
	@ApiField("ip_id")
	private String ipId;

	/**
	 * cif的uid
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 是否计提回转。用于计提收入后，需要冲销的场景
	 */
	@ApiField("is_accrual_reversal")
	private Boolean isAccrualReversal;

	/**
	 * 收款方账号
	 */
	@ApiField("payee_account")
	private String payeeAccount;

	/**
	 * 付款方账号
	 */
	@ApiField("payer_account")
	private String payerAccount;

	/**
	 * 付款对象
	 */
	@ApiField("payer_ip_role_id")
	private String payerIpRoleId;

	/**
	 * 产品码
	 */
	@ApiField("prod_code")
	private String prodCode;

	/**
	 * 产品来源
iptcore：ipay产品中心
mybkptcore：网商产品中心
ptcore：主站产品中心
other：其他产品，未纳入蚂蚁产品体系的产品
acoffercenter：金融云产品中心
	 */
	@ApiField("product_source")
	private String productSource;

	/**
	 * 服务费金额
	 */
	@ApiField("service_amt")
	private MultiCurrencyMoneyOpenApi serviceAmt;

	/**
	 * 结算方式：
01：实时
02：预收
03：后收
04：周期性
	 */
	@ApiField("settle_type")
	private String settleType;

	/**
	 * 来源系统
ACSELLCORE：销管平台
	 */
	@ApiField("source")
	private String source;

	/**
	 * 单据类型：
1：应收账单
23：收入单
	 */
	@ApiField("type")
	private String type;

	/**
	 * 用户来源
icif：ipay用户体系
mybkcif：网商用户体系
cif：主站用户体系
usercenter：金融云用户体系
	 */
	@ApiField("user_source")
	private String userSource;

	public Map getAccountDmsn() {
		return this.accountDmsn;
	}
	public void setAccountDmsn(Map accountDmsn) {
		this.accountDmsn = accountDmsn;
	}

	public String getAgreementNo() {
		return this.agreementNo;
	}
	public void setAgreementNo(String agreementNo) {
		this.agreementNo = agreementNo;
	}

	public String getAgreementSource() {
		return this.agreementSource;
	}
	public void setAgreementSource(String agreementSource) {
		this.agreementSource = agreementSource;
	}

	public MultiCurrencyMoneyOpenApi getBillAmt() {
		return this.billAmt;
	}
	public void setBillAmt(MultiCurrencyMoneyOpenApi billAmt) {
		this.billAmt = billAmt;
	}

	public Date getBillDate() {
		return this.billDate;
	}
	public void setBillDate(Date billDate) {
		this.billDate = billDate;
	}

	public String getBizNo() {
		return this.bizNo;
	}
	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getChargeItemCode() {
		return this.chargeItemCode;
	}
	public void setChargeItemCode(String chargeItemCode) {
		this.chargeItemCode = chargeItemCode;
	}

	public String getChargeOrderNo() {
		return this.chargeOrderNo;
	}
	public void setChargeOrderNo(String chargeOrderNo) {
		this.chargeOrderNo = chargeOrderNo;
	}

	public Long getClcnBasicAmt() {
		return this.clcnBasicAmt;
	}
	public void setClcnBasicAmt(Long clcnBasicAmt) {
		this.clcnBasicAmt = clcnBasicAmt;
	}

	public String getClcnBasicType() {
		return this.clcnBasicType;
	}
	public void setClcnBasicType(String clcnBasicType) {
		this.clcnBasicType = clcnBasicType;
	}

	public Map getExnInfo() {
		return this.exnInfo;
	}
	public void setExnInfo(Map exnInfo) {
		this.exnInfo = exnInfo;
	}

	public String getFundVoucherNo() {
		return this.fundVoucherNo;
	}
	public void setFundVoucherNo(String fundVoucherNo) {
		this.fundVoucherNo = fundVoucherNo;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getIpId() {
		return this.ipId;
	}
	public void setIpId(String ipId) {
		this.ipId = ipId;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public Boolean getIsAccrualReversal() {
		return this.isAccrualReversal;
	}
	public void setIsAccrualReversal(Boolean isAccrualReversal) {
		this.isAccrualReversal = isAccrualReversal;
	}

	public String getPayeeAccount() {
		return this.payeeAccount;
	}
	public void setPayeeAccount(String payeeAccount) {
		this.payeeAccount = payeeAccount;
	}

	public String getPayerAccount() {
		return this.payerAccount;
	}
	public void setPayerAccount(String payerAccount) {
		this.payerAccount = payerAccount;
	}

	public String getPayerIpRoleId() {
		return this.payerIpRoleId;
	}
	public void setPayerIpRoleId(String payerIpRoleId) {
		this.payerIpRoleId = payerIpRoleId;
	}

	public String getProdCode() {
		return this.prodCode;
	}
	public void setProdCode(String prodCode) {
		this.prodCode = prodCode;
	}

	public String getProductSource() {
		return this.productSource;
	}
	public void setProductSource(String productSource) {
		this.productSource = productSource;
	}

	public MultiCurrencyMoneyOpenApi getServiceAmt() {
		return this.serviceAmt;
	}
	public void setServiceAmt(MultiCurrencyMoneyOpenApi serviceAmt) {
		this.serviceAmt = serviceAmt;
	}

	public String getSettleType() {
		return this.settleType;
	}
	public void setSettleType(String settleType) {
		this.settleType = settleType;
	}

	public String getSource() {
		return this.source;
	}
	public void setSource(String source) {
		this.source = source;
	}

	public String getType() {
		return this.type;
	}
	public void setType(String type) {
		this.type = type;
	}

	public String getUserSource() {
		return this.userSource;
	}
	public void setUserSource(String userSource) {
		this.userSource = userSource;
	}

}
