package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 增加发票邮寄信息
 *
 * @author auto create
 * @since 1.0, 2019-12-17 16:01:00
 */
public class AlipayBossFncApinvoiceMailinfobatchAddModel extends AlipayObject {

	private static final long serialVersionUID = 4894662722831783287L;

	/**
	 * 快递公司名称
	 */
	@ApiField("express_company_name")
	private String expressCompanyName;

	/**
	 * 需要添加快递的发票信息列表（至少一条）
	 */
	@ApiListField("invoice_ids")
	@ApiField("string")
	private List<String> invoiceIds;

	/**
	 * 发票邮寄日期 格式yyyyMMdd
	 */
	@ApiField("mail_date")
	private String mailDate;

	/**
	 * 邮寄类型
01-ISV邮寄
02-小二邮寄
	 */
	@ApiField("mail_type")
	private String mailType;

	/**
	 * 创建人
	 */
	@ApiField("operator")
	private String operator;

	/**
	 * 邮寄原因
	 */
	@ApiField("reason")
	private String reason;

	/**
	 * 收件人地址
	 */
	@ApiField("recipients_address")
	private String recipientsAddress;

	/**
	 * 收件人名称
	 */
	@ApiField("recipients_name")
	private String recipientsName;

	/**
	 * 收件人电话
	 */
	@ApiField("recipients_tel")
	private String recipientsTel;

	/**
	 * 寄件人地址
	 */
	@ApiField("sender_address")
	private String senderAddress;

	/**
	 * 寄件人名称
	 */
	@ApiField("sender_name")
	private String senderName;

	/**
	 * 寄件人电话
	 */
	@ApiField("sender_tel")
	private String senderTel;

	/**
	 * 快递号
	 */
	@ApiField("tracking_no")
	private String trackingNo;

	public String getExpressCompanyName() {
		return this.expressCompanyName;
	}
	public void setExpressCompanyName(String expressCompanyName) {
		this.expressCompanyName = expressCompanyName;
	}

	public List<String> getInvoiceIds() {
		return this.invoiceIds;
	}
	public void setInvoiceIds(List<String> invoiceIds) {
		this.invoiceIds = invoiceIds;
	}

	public String getMailDate() {
		return this.mailDate;
	}
	public void setMailDate(String mailDate) {
		this.mailDate = mailDate;
	}

	public String getMailType() {
		return this.mailType;
	}
	public void setMailType(String mailType) {
		this.mailType = mailType;
	}

	public String getOperator() {
		return this.operator;
	}
	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getReason() {
		return this.reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getRecipientsAddress() {
		return this.recipientsAddress;
	}
	public void setRecipientsAddress(String recipientsAddress) {
		this.recipientsAddress = recipientsAddress;
	}

	public String getRecipientsName() {
		return this.recipientsName;
	}
	public void setRecipientsName(String recipientsName) {
		this.recipientsName = recipientsName;
	}

	public String getRecipientsTel() {
		return this.recipientsTel;
	}
	public void setRecipientsTel(String recipientsTel) {
		this.recipientsTel = recipientsTel;
	}

	public String getSenderAddress() {
		return this.senderAddress;
	}
	public void setSenderAddress(String senderAddress) {
		this.senderAddress = senderAddress;
	}

	public String getSenderName() {
		return this.senderName;
	}
	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public String getSenderTel() {
		return this.senderTel;
	}
	public void setSenderTel(String senderTel) {
		this.senderTel = senderTel;
	}

	public String getTrackingNo() {
		return this.trackingNo;
	}
	public void setTrackingNo(String trackingNo) {
		this.trackingNo = trackingNo;
	}

}
