package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 售后单详细数据
 *
 * @author auto create
 * @since 1.0, 2023-07-10 14:16:25
 */
public class AftersaleInfoVO extends AlipayObject {

	private static final long serialVersionUID = 2457793574963135697L;

	/**
	 * 售后单号
	 */
	@ApiField("aftersale_id")
	private String aftersaleId;

	/**
	 * 售后单创建时间
	 */
	@ApiField("create_at")
	private Date createAt;

	/**
	 * 商品信息
	 */
	@ApiField("item_infos")
	private AfterSaleItemInfoVO itemInfos;

	/**
	 * 交易组件订单号
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 商家自定义售后单号
	 */
	@ApiField("out_aftersale_id")
	private String outAftersaleId;

	/**
	 * 商家自定义订单号
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/**
	 * 用户售后原因
	 */
	@ApiField("reason")
	private String reason;

	/**
	 * 退款时间
	 */
	@ApiField("refund_at")
	private Date refundAt;

	/**
	 * 售后单退款金额,单位"元"
	 */
	@ApiField("refund_total_amount")
	private String refundTotalAmount;

	/**
	 * 退款状态,
[{"PROCESSING":"退款中"},{"REFUND_CLOSED":"已退款"},{"SELLER_REJECT":"商户拒绝"},{"BUYER_CANCEL":"买家撤销"}]
	 */
	@ApiField("status")
	private String status;

	public String getAftersaleId() {
		return this.aftersaleId;
	}
	public void setAftersaleId(String aftersaleId) {
		this.aftersaleId = aftersaleId;
	}

	public Date getCreateAt() {
		return this.createAt;
	}
	public void setCreateAt(Date createAt) {
		this.createAt = createAt;
	}

	public AfterSaleItemInfoVO getItemInfos() {
		return this.itemInfos;
	}
	public void setItemInfos(AfterSaleItemInfoVO itemInfos) {
		this.itemInfos = itemInfos;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutAftersaleId() {
		return this.outAftersaleId;
	}
	public void setOutAftersaleId(String outAftersaleId) {
		this.outAftersaleId = outAftersaleId;
	}

	public String getOutOrderId() {
		return this.outOrderId;
	}
	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public String getReason() {
		return this.reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}

	public Date getRefundAt() {
		return this.refundAt;
	}
	public void setRefundAt(Date refundAt) {
		this.refundAt = refundAt;
	}

	public String getRefundTotalAmount() {
		return this.refundTotalAmount;
	}
	public void setRefundTotalAmount(String refundTotalAmount) {
		this.refundTotalAmount = refundTotalAmount;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

}
