package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 售后单凭证信息
 *
 * @author auto create
 * @since 1.0, 2023-07-10 15:47:42
 */
public class AftersaleCertificateInfoVO extends AlipayObject {

	private static final long serialVersionUID = 5199557211584138948L;

	/**
	 * 售后结束时间
	 */
	@ApiField("aftersale_finish_time")
	private Date aftersaleFinishTime;

	/**
	 * 本地商品对应的凭证id
	 */
	@ApiField("certificate_id")
	private String certificateId;

	/**
	 * 售后状态, [{"PROCESSING":"退款中"},{"REFUND_CLOSED":"已退款"},{"SELLER_REJECT":"商户拒绝"},{"BUYER_CANCEL":"买家撤销"}]
	 */
	@ApiField("status")
	private String status;

	public Date getAftersaleFinishTime() {
		return this.aftersaleFinishTime;
	}
	public void setAftersaleFinishTime(Date aftersaleFinishTime) {
		this.aftersaleFinishTime = aftersaleFinishTime;
	}

	public String getCertificateId() {
		return this.certificateId;
	}
	public void setCertificateId(String certificateId) {
		this.certificateId = certificateId;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

}
