package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 预收退款申请数据传输对象
 *
 * @author auto create
 * @since 1.0, 2021-09-28 21:20:29
 */
public class AdvanceRefundApplyDTO extends AlipayObject {

	private static final long serialVersionUID = 4787824212441743775L;

	/**
	 * 申请退款金额
	 */
	@ApiField("apply_refund_amount")
	private MultiCurrencyMoneyOpenApi applyRefundAmount;

	/**
	 * 资金结算系统
	 */
	@ApiField("fund_settle_source")
	private String fundSettleSource;

	/**
	 * 付款OU
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 申请退款的外部单据号
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * 已退款金额
	 */
	@ApiField("refunded_amount")
	private MultiCurrencyMoneyOpenApi refundedAmount;

	/**
	 * 付款对象pid
	 */
	@ApiField("settle_ip_role_id")
	private String settleIpRoleId;

	/**
	 * 退款申请结算状态
WAITING_SETTLE: 初始状态;SETTLED: 退款成功
	 */
	@ApiField("settle_status")
	private String settleStatus;

	/**
	 * 预收退款申请来源
	 */
	@ApiField("source")
	private String source;

	public MultiCurrencyMoneyOpenApi getApplyRefundAmount() {
		return this.applyRefundAmount;
	}
	public void setApplyRefundAmount(MultiCurrencyMoneyOpenApi applyRefundAmount) {
		this.applyRefundAmount = applyRefundAmount;
	}

	public String getFundSettleSource() {
		return this.fundSettleSource;
	}
	public void setFundSettleSource(String fundSettleSource) {
		this.fundSettleSource = fundSettleSource;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public MultiCurrencyMoneyOpenApi getRefundedAmount() {
		return this.refundedAmount;
	}
	public void setRefundedAmount(MultiCurrencyMoneyOpenApi refundedAmount) {
		this.refundedAmount = refundedAmount;
	}

	public String getSettleIpRoleId() {
		return this.settleIpRoleId;
	}
	public void setSettleIpRoleId(String settleIpRoleId) {
		this.settleIpRoleId = settleIpRoleId;
	}

	public String getSettleStatus() {
		return this.settleStatus;
	}
	public void setSettleStatus(String settleStatus) {
		this.settleStatus = settleStatus;
	}

	public String getSource() {
		return this.source;
	}
	public void setSource(String source) {
		this.source = source;
	}

}
