package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 订单基础信息
 *
 * @author auto create
 * @since 1.0, 2022-08-31 15:26:42
 */
public class ActivityOrderBaseInfo extends AlipayObject {

	private static final long serialVersionUID = 6196672467999739118L;

	/**
	 * 下单时间，格式为：yyyy-MM-dd HH:mm:ss。
	 */
	@ApiField("gmt_create")
	private Date gmtCreate;

	/**
	 * 订单号
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 订单状态
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 订单金额。
限制：币种为人名币，单位为元，小数点后最多保留两位。
	 */
	@ApiField("price_info")
	private String priceInfo;

	/**
	 * 购买份数
	 */
	@ApiField("quantity")
	private Long quantity;

	/**
	 * 实付金额。
限制：币种为人名币，单位为元，小数点后最多保留两位。
	 */
	@ApiField("real_pay_price_info")
	private String realPayPriceInfo;

	public Date getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getPriceInfo() {
		return this.priceInfo;
	}
	public void setPriceInfo(String priceInfo) {
		this.priceInfo = priceInfo;
	}

	public Long getQuantity() {
		return this.quantity;
	}
	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}

	public String getRealPayPriceInfo() {
		return this.realPayPriceInfo;
	}
	public void setRealPayPriceInfo(String realPayPriceInfo) {
		this.realPayPriceInfo = realPayPriceInfo;
	}

}
