package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 空滤模型
 *
 * @author auto create
 * @since 1.0, 2020-04-09 15:22:51
 */
public class AcFilterDTO extends AlipayObject {

	private static final long serialVersionUID = 5621192645159914387L;

	/**
	 * 距离下次保养的天数
	 */
	@ApiField("next_mt_days")
	private Long nextMtDays;

	/**
	 * 距离下次保养的里程，km
	 */
	@ApiField("next_mt_miles")
	private Long nextMtMiles;

	/**
	 * 配件id，相应码表如下： A0008 机滤 A0001 机油 A0002 空调滤清 A0004 空气滤清器 A0009 燃油滤清器
	 */
	@ApiField("parts_type_id")
	private String partsTypeId;

	/**
	 * 配件名称
	 */
	@ApiField("parts_type_name")
	private String partsTypeName;

	public Long getNextMtDays() {
		return this.nextMtDays;
	}
	public void setNextMtDays(Long nextMtDays) {
		this.nextMtDays = nextMtDays;
	}

	public Long getNextMtMiles() {
		return this.nextMtMiles;
	}
	public void setNextMtMiles(Long nextMtMiles) {
		this.nextMtMiles = nextMtMiles;
	}

	public String getPartsTypeId() {
		return this.partsTypeId;
	}
	public void setPartsTypeId(String partsTypeId) {
		this.partsTypeId = partsTypeId;
	}

	public String getPartsTypeName() {
		return this.partsTypeName;
	}
	public void setPartsTypeName(String partsTypeName) {
		this.partsTypeName = partsTypeName;
	}

}
