/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.loader.jar.Handler;
import com.taobao.pandora.loader.jar.JarFile;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Map;

public class ReLaunchURLClassLoader
extends URLClassLoader {
    private static LockProvider LOCK_PROVIDER = ReLaunchURLClassLoader.setupLockProvider();
    private final ClassLoader rootClassLoader;
    private Map<String, Class<?>> classCache;

    public ReLaunchURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.rootClassLoader = this.findRootClassLoader(parent);
    }

    private ClassLoader findRootClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.getParent() == null) {
                return classLoader;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    public void setClassCache(Map<String, Class<?>> classCache) {
        this.classCache = classCache;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.rootClassLoader != null) {
            url = this.rootClassLoader.getResource(name);
        }
        return url == null ? this.findResource(name) : url;
    }

    @Override
    public URL findResource(String name) {
        URL uRL;
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            uRL = super.findResource(name);
        }
        catch (Throwable throwable) {
            try {
                Handler.setUseFastConnectionExceptions((boolean)false);
                throw throwable;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        Handler.setUseFastConnectionExceptions((boolean)false);
        return uRL;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.rootClassLoader == null) {
            return this.findResources(name);
        }
        return new ResourceEnumeration(this.rootClassLoader.getResources(name), this.findResources(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = LOCK_PROVIDER.getLock(this, name);
        synchronized (object) {
            if (this.classCache != null && this.classCache.containsKey(name)) {
                return this.classCache.get(name);
            }
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                Handler.setUseFastConnectionExceptions((boolean)true);
                try {
                    loadedClass = this.doLoadClass(name);
                }
                finally {
                    Handler.setUseFastConnectionExceptions((boolean)false);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        try {
            if (this.rootClassLoader != null) {
                return this.rootClassLoader.loadClass(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.findPackage(name);
            Class<?> cls = this.findClass(name);
            return cls;
        }
        catch (Exception exception) {
            return super.loadClass(name, false);
        }
    }

    private void findPackage(String name) throws ClassNotFoundException {
        String packageName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1 && this.getPackage(packageName = name.substring(0, lastDot)) == null) {
            try {
                this.definePackageForFindClass(name, packageName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void definePackageForFindClass(String name, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws ClassNotFoundException {
                    for (URL url : ReLaunchURLClassLoader.this.getURLs()) {
                        Object content = null;
                        try {
                            JarFile jarFile;
                            content = url.getContent();
                            if (!(content instanceof JarFile) || (jarFile = (JarFile)url.getContent()).getManifest() == null) continue;
                            ReLaunchURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            Object var7_8 = null;
                            return var7_8;
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            this.closeIfNecessary(content);
                        }
                    }
                    return null;
                }

                private void closeIfNecessary(Object o) {
                    if (o instanceof Closeable) {
                        try {
                            ((Closeable)o).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static LockProvider setupLockProvider() {
        try {
            ClassLoader.registerAsParallelCapable();
            return new Java7LockProvider();
        }
        catch (NoSuchMethodError ex) {
            return new LockProvider();
        }
    }

    private static class ResourceEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> rootResources;
        private final Enumeration<URL> localResources;

        ResourceEnumeration(Enumeration<URL> rootResources, Enumeration<URL> localResources) {
            this.rootResources = rootResources;
            this.localResources = localResources;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                Handler.setUseFastConnectionExceptions((boolean)true);
                boolean bl = this.rootResources.hasMoreElements() || this.localResources.hasMoreElements();
                return bl;
            }
            finally {
                Handler.setUseFastConnectionExceptions((boolean)false);
            }
        }

        @Override
        public URL nextElement() {
            if (this.rootResources.hasMoreElements()) {
                return this.rootResources.nextElement();
            }
            return this.localResources.nextElement();
        }
    }

    private static class Java7LockProvider
    extends LockProvider {
        private Java7LockProvider() {
        }

        @Override
        public Object getLock(ReLaunchURLClassLoader classLoader, String className) {
            return classLoader.getClassLoadingLock(className);
        }
    }

    private static class LockProvider {
        private LockProvider() {
        }

        public Object getLock(ReLaunchURLClassLoader classLoader, String className) {
            return classLoader;
        }
    }
}

