/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.InputArgumentsJavaAgentDetector;
import com.taobao.pandora.boot.loader.IsolatedThreadGroup;
import com.taobao.pandora.boot.loader.LaunchRunner;
import com.taobao.pandora.boot.loader.ReLaunchURLClassLoader;
import com.taobao.pandora.boot.loader.SarLoaderUtils;
import com.taobao.pandora.boot.loader.jmx.mbean.Health;
import com.taobao.pandora.boot.loader.util.AnsiLog;
import com.taobao.pandora.boot.loader.util.MainClassUtils;
import com.taobao.pandora.boot.loader.util.SystemPrintUtil;
import com.taobao.pandora.loader.archive.Archive;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;

public class ReLaunchMainLauncher {
    public static void main(String[] args) {
        URLClassLoader classLoader = (URLClassLoader)ReLaunchMainLauncher.class.getClassLoader();
        String mainClass = MainClassUtils.detectMainClassFromArgs(args);
        args = MainClassUtils.cleanMainClassFromArgs(args);
        ReLaunchMainLauncher.launch(args, mainClass, classLoader.getURLs());
    }

    public static void launch(String[] args, String mainClass, URL[] urls) {
        long t1 = System.nanoTime();
        Health.registMBean();
        SystemPrintUtil.switchSystemPrint();
        ReLaunchURLClassLoader reLaunchClassLoader = new ReLaunchURLClassLoader(ReLaunchMainLauncher.cleanJavaAgentUrls(urls), ClassLoader.getSystemClassLoader());
        try {
            Archive sar = SarLoaderUtils.findExternalSar();
            if (sar == null && (sar = SarLoaderUtils.findFromClassPath(urls)) == null) {
                if ("true".equalsIgnoreCase(System.getProperty("pandora.boot.failFast"))) {
                    throw new RuntimeException("can not load taobao-hsf.sar, please check your config!");
                }
                AnsiLog.error("Can not load taobao-hsf.sar! If you do not use taobao-hsf.sar, ignore this. Otherwise please check '-Dpandora.location=' or maven dependencies if there contains taobao-hsf.sar!");
            }
            if (sar != null) {
                Map<String, Class<?>> classCache = SarLoaderUtils.getClassCache(sar, reLaunchClassLoader);
                reLaunchClassLoader.setClassCache(classCache);
            }
            SarLoaderUtils.markSarLoaderUtils(reLaunchClassLoader, "sarLoaded", true);
            SarLoaderUtils.markSarLoaderUtils(reLaunchClassLoader, "t1", t1);
        }
        catch (Exception e) {
            throw new RuntimeException("load pandora error!", e);
        }
        ReLaunchMainLauncher.reLaunch(args, mainClass, reLaunchClassLoader);
        System.exit(0);
    }

    private static URL[] cleanJavaAgentUrls(URL[] urls) {
        InputArgumentsJavaAgentDetector javaAgentDetector = new InputArgumentsJavaAgentDetector();
        ArrayList<URL> result = new ArrayList<URL>(urls.length);
        for (URL url : urls) {
            if (javaAgentDetector.isJavaAgentJar(url)) continue;
            result.add(url);
        }
        return result.toArray(new URL[0]);
    }

    public static void reLaunch(String[] args, String mainClass, ClassLoader classLoader) {
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(mainClass);
        Thread launchThread = new Thread(threadGroup, new LaunchRunner(mainClass, args), "main");
        launchThread.setContextClassLoader(classLoader);
        launchThread.start();
        LaunchRunner.join(threadGroup);
        threadGroup.rethrowUncaughtException();
    }
}

