/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.springboot2;

import com.taobao.pandora.boot.spring.ManagementPortUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnWebApplication
@Order(value=0x7FFFFFFF)
@ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties"})
@ConditionalOnProperty(name={"spring.managementSecurityDecetor.enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={ManagementSecurityDecetor.class})
public class ManagementSecurityAutoConfiguration {

    public static class ManagementSecurityDecetor {
        private static final Logger logger = LoggerFactory.getLogger(ManagementSecurityDecetor.class);
        @Autowired
        private ManagementServerProperties managementServerProperties;
        @Autowired
        private ServerProperties serverProperties;

        @PostConstruct
        public void init() {
            if (!ManagementPortUtils.isSafe((Integer)this.serverProperties.getPort(), (Integer)this.managementServerProperties.getPort())) {
                logger.error("server port: {}, management port:{}, is not safe!", (Object)this.serverProperties.getPort(), (Object)this.managementServerProperties.getPort());
                throw new IllegalArgumentException("spring management port is not safe! please add management.server.port=7002 into application.properties.");
            }
        }
    }
}

