/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.springboot2;

import com.taobao.pandora.boot.springboot2.ManagementApplicationcontextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.servlet.ControllerEndpointHandlerMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;

@ControllerEndpoint(id="endpoints")
public class EndPointsEndPoint {
    @Autowired
    private ManagementApplicationcontextHolder contextHolder;
    @Autowired(required=false)
    private WebEndpointsSupplier webEndpointsSupplier;
    @Autowired(required=false)
    private ServletEndpointsSupplier servletEndpointsSupplier;
    @Autowired(required=false)
    private ControllerEndpointsSupplier controllerEndpointsSupplier;

    @RequestMapping
    @ResponseBody
    public List<Map<String, Object>> invoke() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayList allEndpoints = new ArrayList();
        if (this.webEndpointsSupplier != null) {
            allEndpoints.addAll(this.webEndpointsSupplier.getEndpoints());
        }
        if (this.servletEndpointsSupplier != null) {
            allEndpoints.addAll(this.servletEndpointsSupplier.getEndpoints());
        }
        if (this.controllerEndpointsSupplier != null) {
            allEndpoints.addAll(this.controllerEndpointsSupplier.getEndpoints());
        }
        for (ExposableEndpoint endpoint : allEndpoints) {
            HashMap<String, Object> endpointInfo = new HashMap<String, Object>();
            endpointInfo.put("id", endpoint.getId());
            endpointInfo.put("enableByDefault", endpoint.isEnableByDefault());
            result.add(endpointInfo);
        }
        return result;
    }

    @RequestMapping(value={"mappings"})
    @ResponseBody
    public Map<String, Object> mappings() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.extractMethodMappings((ApplicationContext)this.contextHolder.getManagementApplicationContext(), result);
        return result;
    }

    private void extractMethodMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            for (Map.Entry bean : applicationContext.getBeansOfType(AbstractHandlerMethodMapping.class).entrySet()) {
                AbstractHandlerMethodMapping methodMapping = (AbstractHandlerMethodMapping)bean.getValue();
                if (!(methodMapping instanceof AbstractWebMvcEndpointHandlerMapping) && !(methodMapping instanceof ControllerEndpointHandlerMapping)) continue;
                Map methods = ((AbstractHandlerMethodMapping)bean.getValue()).getHandlerMethods();
                for (Map.Entry method : methods.entrySet()) {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("bean", bean.getKey());
                    map.put("method", ((HandlerMethod)method.getValue()).toString());
                    result.put(method.getKey().toString(), map);
                }
            }
        }
    }
}

