/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.json.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.jfunc.json.Json;
import top.jfunc.json.JsonArray;
import top.jfunc.json.JsonObject;
import top.jfunc.json.impl.BaseJson;
import top.jfunc.json.impl.JSONObject;

public class JSONArray
extends BaseJson<JSONArray>
implements JsonArray {
    private com.alibaba.fastjson.JSONArray jsonArray;

    public JSONArray(com.alibaba.fastjson.JSONArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public JSONArray(List<Object> list) {
        this.jsonArray = new com.alibaba.fastjson.JSONArray(list);
    }

    public JSONArray() {
        this.jsonArray = new com.alibaba.fastjson.JSONArray();
    }

    public JSONArray(String arrayString) {
        this.jsonArray = JSON.parseArray((String)arrayString);
    }

    public int size() {
        return this.jsonArray.size();
    }

    public Object get(int index) {
        this.assertIndex(index, this.size());
        return this.checkNullValue(index, this.jsonArray.get(index));
    }

    public String getString(int index) {
        this.assertIndex(index, this.size());
        return (String)this.checkNullValue(index, this.jsonArray.getString(index));
    }

    public Boolean getBoolean(int index) {
        this.assertIndex(index, this.size());
        return (Boolean)this.checkNullValue(index, this.jsonArray.getBoolean(index));
    }

    public Integer getInteger(int index) {
        this.assertIndex(index, this.size());
        return (Integer)this.checkNullValue(index, this.jsonArray.getInteger(index));
    }

    public Long getLong(int index) {
        this.assertIndex(index, this.size());
        return (Long)this.checkNullValue(index, this.jsonArray.getLong(index));
    }

    public Double getDouble(int index) {
        this.assertIndex(index, this.size());
        return (Double)this.checkNullValue(index, this.jsonArray.getDouble(index));
    }

    public Float getFloat(int index) {
        this.assertIndex(index, this.size());
        return (Float)this.checkNullValue(index, this.jsonArray.getFloat(index));
    }

    public BigInteger getBigInteger(int index) {
        this.assertIndex(index, this.size());
        return (BigInteger)this.checkNullValue(index, this.jsonArray.getBigInteger(index));
    }

    public BigDecimal getBigDecimal(int index) {
        this.assertIndex(index, this.size());
        return (BigDecimal)this.checkNullValue(index, this.jsonArray.getBigDecimal(index));
    }

    public JsonObject getJsonObject(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.get(index);
        if (opt instanceof com.alibaba.fastjson.JSONObject) {
            return new JSONObject((com.alibaba.fastjson.JSONObject)opt);
        }
        if (opt instanceof Map) {
            return new JSONObject((Map)opt);
        }
        return (JsonObject)opt;
    }

    public JsonArray getJsonArray(int index) {
        this.assertIndex(index, this.size());
        Object opt = this.jsonArray.get(index);
        if (opt instanceof com.alibaba.fastjson.JSONArray) {
            return new JSONArray((com.alibaba.fastjson.JSONArray)opt);
        }
        if (opt instanceof List) {
            return new JSONArray((List)opt);
        }
        return (JsonArray)opt;
    }

    public JsonArray remove(int index) {
        this.jsonArray.remove(index);
        return this;
    }

    public JsonArray clear() {
        this.jsonArray.clear();
        return this;
    }

    public JsonArray put(Object o) {
        this.jsonArray.add(o);
        return this;
    }

    public JsonArray put(int index, Object o) {
        this.jsonArray.remove(index);
        this.jsonArray.add(index, o);
        return this;
    }

    public JsonArray putAll(Collection<?> os) {
        this.jsonArray.addAll(os);
        return this;
    }

    public JsonArray parse(String jsonString) {
        this.jsonArray = JSON.parseArray((String)jsonString);
        return this;
    }

    public com.alibaba.fastjson.JSONArray unwrap() {
        return this.jsonArray;
    }

    public String toString() {
        HashMap<Integer, Json> map = new HashMap<Integer, Json>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object o = this.jsonArray.get(i);
            if (!(o instanceof JsonObject) && !(o instanceof JsonArray)) continue;
            map.put(i, (Json)o);
        }
        map.forEach((k, v) -> {
            this.jsonArray.remove(k.intValue());
            this.jsonArray.add(k.intValue(), v.unwrap());
        });
        return this.jsonArray.toString();
    }

    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    public boolean equals(Object obj) {
        return this.jsonArray.equals(obj);
    }

    public JsonArray fromList(List<Object> list) {
        this.jsonArray = new com.alibaba.fastjson.JSONArray(list);
        return this;
    }
}

