/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes;
import software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEmailIdentityDkimSigningAttributesRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, PutEmailIdentityDkimSigningAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailIdentity").getter(PutEmailIdentityDkimSigningAttributesRequest.getter(PutEmailIdentityDkimSigningAttributesRequest::emailIdentity)).setter(PutEmailIdentityDkimSigningAttributesRequest.setter(Builder::emailIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()}).build();
    private static final SdkField<String> SIGNING_ATTRIBUTES_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAttributesOrigin").getter(PutEmailIdentityDkimSigningAttributesRequest.getter(PutEmailIdentityDkimSigningAttributesRequest::signingAttributesOriginAsString)).setter(PutEmailIdentityDkimSigningAttributesRequest.setter(Builder::signingAttributesOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributesOrigin").build()}).build();
    private static final SdkField<DkimSigningAttributes> SIGNING_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SigningAttributes").getter(PutEmailIdentityDkimSigningAttributesRequest.getter(PutEmailIdentityDkimSigningAttributesRequest::signingAttributes)).setter(PutEmailIdentityDkimSigningAttributesRequest.setter(Builder::signingAttributes)).constructor(DkimSigningAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD, SIGNING_ATTRIBUTES_ORIGIN_FIELD, SIGNING_ATTRIBUTES_FIELD));
    private final String emailIdentity;
    private final String signingAttributesOrigin;
    private final DkimSigningAttributes signingAttributes;

    private PutEmailIdentityDkimSigningAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.signingAttributesOrigin = builder.signingAttributesOrigin;
        this.signingAttributes = builder.signingAttributes;
    }

    public final String emailIdentity() {
        return this.emailIdentity;
    }

    public final DkimSigningAttributesOrigin signingAttributesOrigin() {
        return DkimSigningAttributesOrigin.fromValue(this.signingAttributesOrigin);
    }

    public final String signingAttributesOriginAsString() {
        return this.signingAttributesOrigin;
    }

    public final DkimSigningAttributes signingAttributes() {
        return this.signingAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAttributesOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityDkimSigningAttributesRequest)) {
            return false;
        }
        PutEmailIdentityDkimSigningAttributesRequest other = (PutEmailIdentityDkimSigningAttributesRequest)((Object)obj);
        return Objects.equals(this.emailIdentity(), other.emailIdentity()) && Objects.equals(this.signingAttributesOriginAsString(), other.signingAttributesOriginAsString()) && Objects.equals(this.signingAttributes(), other.signingAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"PutEmailIdentityDkimSigningAttributesRequest").add("EmailIdentity", (Object)this.emailIdentity()).add("SigningAttributesOrigin", (Object)this.signingAttributesOriginAsString()).add("SigningAttributes", (Object)this.signingAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailIdentity": {
                return Optional.ofNullable(clazz.cast(this.emailIdentity()));
            }
            case "SigningAttributesOrigin": {
                return Optional.ofNullable(clazz.cast(this.signingAttributesOriginAsString()));
            }
            case "SigningAttributes": {
                return Optional.ofNullable(clazz.cast(this.signingAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityDkimSigningAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityDkimSigningAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String emailIdentity;
        private String signingAttributesOrigin;
        private DkimSigningAttributes signingAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityDkimSigningAttributesRequest model) {
            super(model);
            this.emailIdentity(model.emailIdentity);
            this.signingAttributesOrigin(model.signingAttributesOrigin);
            this.signingAttributes(model.signingAttributes);
        }

        public final String getEmailIdentity() {
            return this.emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        public final String getSigningAttributesOrigin() {
            return this.signingAttributesOrigin;
        }

        @Override
        public final Builder signingAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
            return this;
        }

        @Override
        public final Builder signingAttributesOrigin(DkimSigningAttributesOrigin signingAttributesOrigin) {
            this.signingAttributesOrigin(signingAttributesOrigin == null ? null : signingAttributesOrigin.toString());
            return this;
        }

        public final void setSigningAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
        }

        public final DkimSigningAttributes.Builder getSigningAttributes() {
            return this.signingAttributes != null ? this.signingAttributes.toBuilder() : null;
        }

        @Override
        public final Builder signingAttributes(DkimSigningAttributes signingAttributes) {
            this.signingAttributes = signingAttributes;
            return this;
        }

        public final void setSigningAttributes(DkimSigningAttributes.BuilderImpl signingAttributes) {
            this.signingAttributes = signingAttributes != null ? signingAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityDkimSigningAttributesRequest build() {
            return new PutEmailIdentityDkimSigningAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEmailIdentityDkimSigningAttributesRequest> {
        public Builder emailIdentity(String var1);

        public Builder signingAttributesOrigin(String var1);

        public Builder signingAttributesOrigin(DkimSigningAttributesOrigin var1);

        public Builder signingAttributes(DkimSigningAttributes var1);

        default public Builder signingAttributes(Consumer<DkimSigningAttributes.Builder> signingAttributes) {
            return this.signingAttributes((DkimSigningAttributes)((DkimSigningAttributes.Builder)DkimSigningAttributes.builder().applyMutation(signingAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

