/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeviceState {
    PROVISIONED("Provisioned"),
    REGISTERED_NOT_SEEN("RegisteredNotSeen"),
    REGISTERED_REACHABLE("RegisteredReachable"),
    REGISTERED_UNREACHABLE("RegisteredUnreachable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeviceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeviceState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceState> knownValues() {
        return Stream.of(DeviceState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

