/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.executors;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import redis.clients.jedis.util.IOUtils;

public class CircuitBreakerCommandExecutor
implements CommandExecutor {
    private static final List<Class<? extends Throwable>> circuitBreakerFallbackException = Arrays.asList(CallNotPermittedException.class);
    private final MultiClusterPooledConnectionProvider provider;

    public CircuitBreakerCommandExecutor(MultiClusterPooledConnectionProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.provider);
    }

    @Override
    public <T> T executeCommand(CommandObject<T> commandObject) {
        MultiClusterPooledConnectionProvider.Cluster cluster = this.provider.getCluster();
        Decorators.DecorateSupplier supplier = Decorators.ofSupplier(() -> this.handleExecuteCommand(commandObject, cluster));
        supplier.withRetry(cluster.getRetry());
        supplier.withCircuitBreaker(cluster.getCircuitBreaker());
        supplier.withFallback(circuitBreakerFallbackException, e -> this.handleClusterFailover(commandObject, cluster.getCircuitBreaker()));
        return supplier.decorate().get();
    }

    private <T> T handleExecuteCommand(CommandObject<T> commandObject, MultiClusterPooledConnectionProvider.Cluster cluster) {
        try (Connection connection = cluster.getConnection();){
            T t = connection.executeCommand(commandObject);
            return t;
        }
    }

    private synchronized <T> T handleClusterFailover(CommandObject<T> commandObject, CircuitBreaker circuitBreaker) {
        if (!CircuitBreaker.State.FORCED_OPEN.equals((Object)circuitBreaker.getState())) {
            circuitBreaker.transitionToForcedOpenState();
            int activeMultiClusterIndex = this.provider.incrementActiveMultiClusterIndex();
            this.provider.runClusterFailoverPostProcessor(activeMultiClusterIndex);
        } else if (this.provider.isLastClusterCircuitBreakerForcedOpen()) {
            throw new JedisConnectionException("Cluster/database endpoint could not failover since the MultiClusterClientConfig was not provided with an additional cluster/database endpoint according to its prioritized sequence. If applicable, consider failing back OR restarting with an available cluster/database endpoint");
        }
        return this.executeCommand(commandObject);
    }
}

