/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.SearchProtocol;

public class IndexDefinition
implements IParams {
    private final Type type;
    private boolean async = false;
    private String[] prefixes;
    private String filter;
    private String languageField;
    private String language;
    private String scoreFiled;
    private double score = 1.0;
    private String payloadField;

    public IndexDefinition() {
        this(null);
    }

    public IndexDefinition(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isAsync() {
        return this.async;
    }

    public IndexDefinition setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public IndexDefinition setPrefixes(String ... prefixes) {
        this.prefixes = prefixes;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public IndexDefinition setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getLanguageField() {
        return this.languageField;
    }

    public IndexDefinition setLanguageField(String languageField) {
        this.languageField = languageField;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public IndexDefinition setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getScoreFiled() {
        return this.scoreFiled;
    }

    public IndexDefinition setScoreFiled(String scoreFiled) {
        this.scoreFiled = scoreFiled;
        return this;
    }

    public double getScore() {
        return this.score;
    }

    public IndexDefinition setScore(double score) {
        this.score = score;
        return this;
    }

    public String getPayloadField() {
        return this.payloadField;
    }

    @Deprecated
    public IndexDefinition setPayloadField(String payloadField) {
        this.payloadField = payloadField;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.type != null) {
            args.add(SearchProtocol.SearchKeyword.ON.name());
            args.add(this.type.name());
        }
        if (this.async) {
            args.add(SearchProtocol.SearchKeyword.ASYNC.name());
        }
        if (this.prefixes != null && this.prefixes.length > 0) {
            args.add(SearchProtocol.SearchKeyword.PREFIX.name());
            args.add(Integer.toString(this.prefixes.length));
            args.addObjects(this.prefixes);
        }
        if (this.filter != null) {
            args.add(SearchProtocol.SearchKeyword.FILTER.name());
            args.add(this.filter);
        }
        if (this.languageField != null) {
            args.add(SearchProtocol.SearchKeyword.LANGUAGE_FIELD.name());
            args.add(this.languageField);
        }
        if (this.language != null) {
            args.add(SearchProtocol.SearchKeyword.LANGUAGE.name());
            args.add(this.language);
        }
        if (this.scoreFiled != null) {
            args.add(SearchProtocol.SearchKeyword.SCORE_FIELD.name());
            args.add(this.scoreFiled);
        }
        if (this.score != 1.0) {
            args.add(SearchProtocol.SearchKeyword.SCORE.name());
            args.add(Double.toString(this.score));
        }
        if (this.payloadField != null) {
            args.add(SearchProtocol.SearchKeyword.PAYLOAD_FIELD.name());
            args.add(this.payloadField);
        }
    }

    public static enum Type {
        HASH,
        JSON;

    }
}

