/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.event;

import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.ext.Pageable;

public class PagingEvent
extends Event {
    private final Pageable _pgi;
    private final int _actpg;

    public static final PagingEvent getPagingEvent(AuRequest request) {
        Component comp = request.getComponent();
        Map data = request.getData();
        int pgi = AuRequests.getInt((Map)data, (String)"", (int)0);
        Pageable pageable = (Pageable)comp;
        if (pgi < 0) {
            pgi = 0;
        } else {
            int pgcnt = pageable.getPageCount();
            if (pgi >= pgcnt && (pgi = pgcnt - 1) < 0) {
                pgi = 0;
            }
        }
        return new PagingEvent(request.getCommand(), comp, pgi);
    }

    public PagingEvent(String name, Component target, int actpg) {
        super(name, target);
        this._pgi = (Pageable)target;
        this._actpg = actpg;
    }

    public PagingEvent(String name, Component target, Pageable pageable, int actpg) {
        super(name, target);
        this._pgi = pageable;
        this._actpg = actpg;
    }

    public Pageable getPageable() {
        return this._pgi;
    }

    public int getActivePage() {
        return this._actpg;
    }
}

