/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.AioDecodeException;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpMultiBodyDecoder;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.Method;
import org.tio.http.common.RequestLine;
import org.tio.http.common.utils.HttpParseUtils;
import org.tio.http.common.utils.IpUtils;
import org.tio.utils.hutool.StrUtil;

public class HttpRequestDecoder {
    private static Logger log = LoggerFactory.getLogger(HttpRequestDecoder.class);
    public static final int MAX_LENGTH_OF_HEADER = 20480;
    public static final int MAX_LENGTH_OF_HEADERLINE = 2048;
    public static final int MAX_LENGTH_OF_REQUESTLINE = 2048;

    public static HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext, HttpConfig httpConfig) throws AioDecodeException {
        HashMap<String, String> headers = new HashMap<String, String>();
        int contentLength = 0;
        byte[] bodyBytes = null;
        RequestLine firstLine = null;
        firstLine = HttpRequestDecoder.parseRequestLine(buffer, channelContext);
        if (firstLine == null) {
            return null;
        }
        boolean headerCompleted = HttpRequestDecoder.parseHeaderLine(buffer, headers, 0, httpConfig);
        if (!headerCompleted) {
            return null;
        }
        String contentLengthStr = (String)headers.get("content-length");
        if (StrUtil.isBlank((CharSequence)contentLengthStr)) {
            contentLength = 0;
        } else {
            contentLength = Integer.parseInt(contentLengthStr);
            if (contentLength > httpConfig.getMaxLengthOfPostBody()) {
                throw new AioDecodeException("post body length is too big[" + contentLength + "], max length is " + httpConfig.getMaxLengthOfPostBody() + " byte");
            }
        }
        int headerLength = buffer.position() - position;
        int allNeedLength = headerLength + contentLength;
        int notReceivedLength = allNeedLength - readableLength;
        if (notReceivedLength > 0) {
            if (notReceivedLength > channelContext.getReadBufferSize()) {
                channelContext.setReadBufferSize(Integer.valueOf(notReceivedLength));
            }
            channelContext.setPacketNeededLength(Integer.valueOf(allNeedLength));
            return null;
        }
        String realIp = IpUtils.getRealIp(channelContext, httpConfig, headers);
        if (Tio.IpBlacklist.isInBlacklist((TioConfig)channelContext.tioConfig, (String)realIp)) {
            throw new AioDecodeException("[" + realIp + "] in black list");
        }
        if (httpConfig.checkHost && !headers.containsKey("host")) {
            throw new AioDecodeException("there is no host header");
        }
        Node realNode = null;
        if (Objects.equals(realIp, channelContext.getClientNode().getIp())) {
            realNode = channelContext.getClientNode();
        } else {
            realNode = new Node(realIp, channelContext.getClientNode().getPort());
            channelContext.setProxyClientNode(realNode);
        }
        HttpRequest httpRequest = new HttpRequest(realNode);
        httpRequest.setRequestLine(firstLine);
        httpRequest.setChannelContext(channelContext);
        httpRequest.setHttpConfig(httpConfig);
        httpRequest.setHeaders(headers);
        httpRequest.setContentLength(contentLength);
        String connection = (String)headers.get("connection");
        if (connection != null) {
            httpRequest.setConnection(connection.toLowerCase());
        }
        if (StrUtil.isNotBlank((CharSequence)firstLine.queryString)) {
            HttpRequestDecoder.decodeParams(httpRequest.getParams(), firstLine.queryString, httpRequest.getCharset(), channelContext);
        }
        if (contentLength > 0) {
            bodyBytes = new byte[contentLength];
            buffer.get(bodyBytes);
            httpRequest.setBody(bodyBytes);
            HttpRequestDecoder.parseBody(httpRequest, firstLine, bodyBytes, channelContext, httpConfig);
        }
        return httpRequest;
    }

    public static void decodeParams(Map<String, Object[]> params, String queryString, String charset, ChannelContext channelContext) throws AioDecodeException {
        String[] keyvalues;
        if (StrUtil.isBlank((CharSequence)queryString)) {
            return;
        }
        for (String keyvalue : keyvalues = queryString.split("&")) {
            String[] newExistValue;
            String value;
            String[] keyvalueArr = keyvalue.split("=");
            String value1 = null;
            if (keyvalueArr.length == 2) {
                value1 = keyvalueArr[1];
            } else if (keyvalueArr.length > 2) {
                throw new AioDecodeException("\u542b\u6709\u591a\u4e2a=");
            }
            String key = keyvalueArr[0];
            if (StrUtil.isBlank((CharSequence)value1)) {
                value = null;
            } else {
                try {
                    value = URLDecoder.decode(value1, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AioDecodeException((Throwable)e);
                }
            }
            Object[] existValue = params.get(key);
            if (existValue != null) {
                newExistValue = new String[existValue.length + 1];
                System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
                newExistValue[newExistValue.length - 1] = value;
                params.put(key, newExistValue);
                continue;
            }
            newExistValue = new String[]{value};
            params.put(key, newExistValue);
        }
    }

    private static void parseBody(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, ChannelContext channelContext, HttpConfig httpConfig) throws AioDecodeException {
        HttpRequestDecoder.parseBodyFormat(httpRequest, httpRequest.getHeaders());
        HttpConst.RequestBodyFormat bodyFormat = httpRequest.getBodyFormat();
        httpRequest.setBody(bodyBytes);
        switch (bodyFormat) {
            case MULTIPART: {
                if (log.isInfoEnabled()) {
                    String bodyString = null;
                    if (bodyBytes != null && bodyBytes.length > 0 && log.isDebugEnabled()) {
                        try {
                            bodyString = new String(bodyBytes, httpRequest.getCharset());
                            log.debug("{} multipart body value\r\n{}", (Object)channelContext, (Object)bodyString);
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error(channelContext.toString(), (Throwable)e);
                        }
                    }
                }
                String contentType = httpRequest.getHeader("content-type");
                String initboundary = HttpParseUtils.getSubAttribute(contentType, "boundary");
                if (log.isDebugEnabled()) {
                    log.debug("{}, initboundary:{}", (Object)channelContext, (Object)initboundary);
                }
                HttpMultiBodyDecoder.decode(httpRequest, firstLine, bodyBytes, initboundary, channelContext, httpConfig);
                break;
            }
            default: {
                String bodyString = null;
                if (bodyBytes != null && bodyBytes.length > 0) {
                    try {
                        bodyString = new String(bodyBytes, httpRequest.getCharset());
                        httpRequest.setBodyString(bodyString);
                        if (log.isInfoEnabled()) {
                            log.info("{} body value\r\n{}", (Object)channelContext, (Object)bodyString);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(channelContext.toString(), (Throwable)e);
                    }
                }
                if (bodyFormat != HttpConst.RequestBodyFormat.URLENCODED) break;
                HttpRequestDecoder.parseUrlencoded(httpRequest, firstLine, bodyBytes, bodyString, channelContext);
            }
        }
    }

    public static void parseBodyFormat(HttpRequest httpRequest, Map<String, String> headers) {
        String contentType = headers.get("content-type");
        String Content_Type2 = null;
        if (contentType != null) {
            Content_Type2 = contentType.toLowerCase();
        }
        if (Content_Type2.startsWith("text/plain")) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.TEXT);
        } else if (Content_Type2.startsWith("multipart/form-data")) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.MULTIPART);
        } else {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.URLENCODED);
        }
        if (StrUtil.isNotBlank((CharSequence)Content_Type2)) {
            String charset = HttpParseUtils.getSubAttribute(Content_Type2, "charset");
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                httpRequest.setCharset(charset);
            } else {
                httpRequest.setCharset("utf-8");
            }
        }
    }

    public static boolean parseHeaderLine(ByteBuffer buffer, Map<String, String> headers, int hasReceivedHeaderLength, HttpConfig httpConfig) throws AioDecodeException {
        int lineLength;
        int initPosition;
        if (!buffer.hasArray()) {
            return HttpRequestDecoder.parseHeaderLine2(buffer, headers, hasReceivedHeaderLength, httpConfig);
        }
        byte[] allbs = buffer.array();
        int lastPosition = initPosition = buffer.position();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return false;
        }
        if (remaining > 1) {
            byte b1 = buffer.get();
            byte b2 = buffer.get();
            if (13 == b1 && 10 == b2) {
                return true;
            }
            if (10 == b1) {
                return true;
            }
        } else if (10 == buffer.get()) {
            return true;
        }
        String name = null;
        String value = null;
        boolean hasValue = false;
        boolean needIteration = false;
        while (buffer.hasRemaining()) {
            byte lastByte;
            byte b = buffer.get();
            if (name == null) {
                if (b == 58) {
                    int len = buffer.position() - lastPosition - 1;
                    name = new String(allbs, lastPosition, len);
                    lastPosition = buffer.position();
                    continue;
                }
                if (b != 10) continue;
                lastByte = buffer.get(buffer.position() - 2);
                int len = buffer.position() - lastPosition - 1;
                if (lastByte == 13) {
                    len = buffer.position() - lastPosition - 2;
                }
                name = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                headers.put(name.toLowerCase(), "");
                needIteration = true;
                break;
            }
            if (value != null) continue;
            if (b == 10) {
                lastByte = buffer.get(buffer.position() - 2);
                int len = buffer.position() - lastPosition - 1;
                if (lastByte == 13) {
                    len = buffer.position() - lastPosition - 2;
                }
                value = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                headers.put(name.toLowerCase(), StrUtil.trimEnd((CharSequence)value));
                needIteration = true;
                break;
            }
            if (!hasValue && b == 32) {
                lastPosition = buffer.position();
                continue;
            }
            hasValue = true;
        }
        if ((lineLength = buffer.position() - initPosition) > 2048) {
            throw new AioDecodeException("header line is too long, max length of header line is 2048");
        }
        if (needIteration) {
            int headerLength = lineLength + hasReceivedHeaderLength;
            if (headerLength > 20480) {
                throw new AioDecodeException("header is too long, max length of header is 20480");
            }
            return HttpRequestDecoder.parseHeaderLine(buffer, headers, headerLength, httpConfig);
        }
        return false;
    }

    private static boolean parseHeaderLine2(ByteBuffer buffer, Map<String, String> headers, int headerLength, HttpConfig httpConfig) throws AioDecodeException {
        int initPosition;
        int lastPosition = initPosition = buffer.position();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return false;
        }
        if (remaining > 1) {
            byte b1 = buffer.get();
            byte b2 = buffer.get();
            if (13 == b1 && 10 == b2) {
                return true;
            }
            if (10 == b1) {
                return true;
            }
        } else if (10 == buffer.get()) {
            return true;
        }
        String name = null;
        String value = null;
        boolean hasValue = false;
        boolean needIteration = false;
        while (buffer.hasRemaining()) {
            byte[] bs;
            int nowPosition;
            byte b = buffer.get();
            if (name == null) {
                if (b == 58) {
                    nowPosition = buffer.position();
                    bs = new byte[nowPosition - lastPosition - 1];
                    buffer.position(lastPosition);
                    buffer.get(bs);
                    name = new String(bs);
                    lastPosition = nowPosition;
                    buffer.position(nowPosition);
                    continue;
                }
                if (b != 10) continue;
                nowPosition = buffer.position();
                bs = null;
                byte lastByte = buffer.get(nowPosition - 2);
                bs = lastByte == 13 ? new byte[nowPosition - lastPosition - 2] : new byte[nowPosition - lastPosition - 1];
                buffer.position(lastPosition);
                buffer.get(bs);
                name = new String(bs);
                lastPosition = nowPosition;
                buffer.position(nowPosition);
                headers.put(name.toLowerCase(), null);
                needIteration = true;
                break;
            }
            if (value != null) continue;
            if (b == 10) {
                nowPosition = buffer.position();
                bs = null;
                byte lastByte = buffer.get(nowPosition - 2);
                bs = lastByte == 13 ? new byte[nowPosition - lastPosition - 2] : new byte[nowPosition - lastPosition - 1];
                buffer.position(lastPosition);
                buffer.get(bs);
                value = new String(bs);
                lastPosition = nowPosition;
                buffer.position(nowPosition);
                headers.put(name.toLowerCase(), StrUtil.trimEnd((CharSequence)value));
                needIteration = true;
                break;
            }
            if (!hasValue && b == 32) {
                lastPosition = buffer.position();
                continue;
            }
            hasValue = true;
        }
        if (needIteration) {
            int myHeaderLength = buffer.position() - initPosition;
            if (myHeaderLength > 20480) {
                throw new AioDecodeException("header is too long");
            }
            return HttpRequestDecoder.parseHeaderLine(buffer, headers, myHeaderLength + headerLength, httpConfig);
        }
        if (remaining > 2048) {
            throw new AioDecodeException("header line is too long");
        }
        return false;
    }

    public static RequestLine parseRequestLine(ByteBuffer buffer, ChannelContext channelContext) throws AioDecodeException {
        if (!buffer.hasArray()) {
            return HttpRequestDecoder.parseRequestLine2(buffer, channelContext);
        }
        byte[] allbs = buffer.array();
        int initPosition = buffer.position();
        String methodStr = null;
        String pathStr = null;
        String queryStr = null;
        String protocol = null;
        String version = null;
        int lastPosition = initPosition;
        while (buffer.hasRemaining()) {
            int len;
            byte b = buffer.get();
            if (methodStr == null) {
                if (b != 32) continue;
                len = buffer.position() - lastPosition - 1;
                methodStr = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (pathStr == null) {
                if (b != 32 && b != 63) continue;
                len = buffer.position() - lastPosition - 1;
                pathStr = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                if (b != 32) continue;
                queryStr = "";
                continue;
            }
            if (queryStr == null) {
                if (b != 32) continue;
                len = buffer.position() - lastPosition - 1;
                queryStr = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (protocol == null) {
                if (b != 47) continue;
                len = buffer.position() - lastPosition - 1;
                protocol = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (version != null || b != 10) continue;
            byte lastByte = buffer.get(buffer.position() - 2);
            int len2 = buffer.position() - lastPosition - 1;
            if (lastByte == 13) {
                len2 = buffer.position() - lastPosition - 2;
            }
            version = new String(allbs, lastPosition, len2);
            lastPosition = buffer.position();
            RequestLine requestLine = new RequestLine();
            Method method = Method.from(methodStr);
            requestLine.setMethod(method);
            requestLine.setPath(pathStr);
            requestLine.setInitPath(pathStr);
            requestLine.setQueryString(queryStr);
            requestLine.setProtocol(protocol);
            requestLine.setVersion(version);
            return requestLine;
        }
        if (buffer.position() - initPosition > 2048) {
            throw new AioDecodeException("request line is too long");
        }
        return null;
    }

    private static RequestLine parseRequestLine2(ByteBuffer buffer, ChannelContext channelContext) throws AioDecodeException {
        int initPosition = buffer.position();
        String methodStr = null;
        String pathStr = null;
        String queryStr = null;
        String protocol = null;
        String version = null;
        int lastPosition = initPosition;
        while (buffer.hasRemaining()) {
            byte[] bs;
            int nowPosition;
            byte b = buffer.get();
            if (methodStr == null) {
                if (b != 32) continue;
                nowPosition = buffer.position();
                bs = new byte[nowPosition - lastPosition - 1];
                buffer.position(lastPosition);
                buffer.get(bs);
                methodStr = new String(bs);
                lastPosition = nowPosition;
                buffer.position(nowPosition);
                continue;
            }
            if (pathStr == null) {
                if (b != 32 && b != 63) continue;
                nowPosition = buffer.position();
                bs = new byte[nowPosition - lastPosition - 1];
                buffer.position(lastPosition);
                buffer.get(bs);
                pathStr = new String(bs);
                lastPosition = nowPosition;
                buffer.position(nowPosition);
                if (b != 32) continue;
                queryStr = "";
                continue;
            }
            if (queryStr == null) {
                if (b != 32) continue;
                nowPosition = buffer.position();
                bs = new byte[nowPosition - lastPosition - 1];
                buffer.position(lastPosition);
                buffer.get(bs);
                queryStr = new String(bs);
                lastPosition = nowPosition;
                buffer.position(nowPosition);
                continue;
            }
            if (protocol == null) {
                if (b != 47) continue;
                nowPosition = buffer.position();
                bs = new byte[nowPosition - lastPosition - 1];
                buffer.position(lastPosition);
                buffer.get(bs);
                protocol = new String(bs);
                lastPosition = nowPosition;
                buffer.position(nowPosition);
                continue;
            }
            if (version != null || b != 10) continue;
            nowPosition = buffer.position();
            bs = null;
            byte lastByte = buffer.get(nowPosition - 2);
            bs = lastByte == 13 ? new byte[nowPosition - lastPosition - 2] : new byte[nowPosition - lastPosition - 1];
            buffer.position(lastPosition);
            buffer.get(bs);
            version = new String(bs);
            lastPosition = nowPosition;
            buffer.position(nowPosition);
            RequestLine requestLine = new RequestLine();
            Method method = Method.from(methodStr);
            requestLine.setMethod(method);
            requestLine.setPath(pathStr);
            requestLine.setInitPath(pathStr);
            requestLine.setQueryString(queryStr);
            requestLine.setProtocol(protocol);
            requestLine.setVersion(version);
            return requestLine;
        }
        if (buffer.position() - initPosition > 2048) {
            throw new AioDecodeException("request line is too long");
        }
        return null;
    }

    private static void parseUrlencoded(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, String bodyString, ChannelContext channelContext) throws AioDecodeException {
        HttpRequestDecoder.decodeParams(httpRequest.getParams(), bodyString, httpRequest.getCharset(), channelContext);
    }

    public static enum Step {
        firstline,
        header,
        body;

    }
}

