/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.springframework.beans.BeansException;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.filter.reactive.ServerHttpObservationFilter;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private boolean lazyInitHandlers = false;
    private final Map<PathPattern, Object> handlerMap = new LinkedHashMap<PathPattern, Object>();
    @Nullable
    private BiPredicate<Object, ServerWebExchange> handlerPredicate;

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public final Map<PathPattern, Object> getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    public void setHandlerPredicate(BiPredicate<Object, ServerWebExchange> handlerPredicate) {
        this.handlerPredicate = this.handlerPredicate != null ? this.handlerPredicate.and(handlerPredicate) : handlerPredicate;
    }

    public Mono<Object> getHandlerInternal(ServerWebExchange exchange) {
        Object handler;
        PathContainer lookupPath = exchange.getRequest().getPath().pathWithinApplication();
        try {
            handler = this.lookupHandler(lookupPath, exchange);
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
        return Mono.justOrEmpty((Object)handler);
    }

    @Nullable
    protected Object lookupHandler(PathContainer lookupPath, ServerWebExchange exchange) throws Exception {
        List matches = null;
        for (PathPattern pattern : this.handlerMap.keySet()) {
            if (!pattern.matches(lookupPath)) continue;
            matches = matches != null ? matches : new ArrayList();
            matches.add(pattern);
        }
        if (matches == null) {
            return null;
        }
        if (matches.size() > 1) {
            matches.sort(PathPattern.SPECIFICITY_COMPARATOR);
            if (this.logger.isTraceEnabled()) {
                this.logger.debug((Object)(exchange.getLogPrefix() + "Matching patterns " + matches));
            }
        }
        PathPattern pattern = (PathPattern)matches.get(0);
        PathContainer pathWithinMapping = pattern.extractPathWithinPattern(lookupPath);
        PathPattern.PathMatchInfo matchInfo = pattern.matchAndExtract(lookupPath);
        Assert.notNull((Object)matchInfo, (String)"Expected a match");
        Object handler = this.handlerMap.get(pattern);
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.obtainApplicationContext().getBean(handlerName);
        }
        if (this.handlerPredicate != null && !this.handlerPredicate.test(handler, exchange)) {
            return null;
        }
        this.validateHandler(handler, exchange);
        exchange.getAttributes().put(BEST_MATCHING_HANDLER_ATTRIBUTE, handler);
        exchange.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, pattern);
        ServerHttpObservationFilter.findObservationContext((ServerWebExchange)exchange).ifPresent(context -> context.setPathPattern(pattern.toString()));
        exchange.getAttributes().put(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, pathWithinMapping);
        exchange.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, matchInfo.getUriVariables());
        return handler;
    }

    protected void validateHandler(Object handler, ServerWebExchange exchange) {
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array must not be null");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object existingHandler;
        Assert.notNull((Object)urlPath, (String)"URL path must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        PathPatternParser parser = this.getPathPatternParser();
        urlPath = parser.initFullPathPattern(urlPath);
        PathPattern pattern = parser.parse(urlPath);
        if (this.handlerMap.containsKey(pattern) && (existingHandler = this.handlerMap.get(pattern)) != null && existingHandler != resolvedHandler) {
            throw new IllegalStateException("Cannot map " + this.getHandlerDescription(handler) + " to [" + urlPath + "]: there is already " + this.getHandlerDescription(existingHandler) + " mapped.");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.obtainApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.obtainApplicationContext().getBean(handlerName);
            }
        }
        this.handlerMap.put(pattern, resolvedHandler);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Mapped [" + urlPath + "] onto " + this.getHandlerDescription(handler)));
        }
    }

    private String getHandlerDescription(Object handler) {
        return handler instanceof String ? "'" + handler + "'" : handler.toString();
    }
}

