/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;
import org.springframework.util.Assert;

public class BurlapClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    private BurlapProxyFactory proxyFactory = new BurlapProxyFactory();
    private Object burlapProxy;

    public void setProxyFactory(BurlapProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory != null ? proxyFactory : new BurlapProxyFactory();
    }

    public void setUsername(String username) {
        this.proxyFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.proxyFactory.setPassword(password);
    }

    public void setOverloadEnabled(boolean overloadEnabled) {
        this.proxyFactory.setOverloadEnabled(overloadEnabled);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() throws RemoteLookupFailureException {
        try {
            this.burlapProxy = this.createBurlapProxy(this.proxyFactory);
        }
        catch (MalformedURLException ex) {
            throw new RemoteLookupFailureException("Service URL [" + this.getServiceUrl() + "] is invalid", (Throwable)ex);
        }
    }

    protected Object createBurlapProxy(BurlapProxyFactory proxyFactory) throws MalformedURLException {
        Assert.notNull((Object)this.getServiceInterface(), (String)"Property 'serviceInterface' is required");
        return proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        if (this.burlapProxy == null) {
            throw new IllegalStateException("BurlapClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            try {
                object = invocation.getMethod().invoke(this.burlapProxy, invocation.getArguments());
                Object var7_6 = null;
            }
            catch (InvocationTargetException ex) {
                if (!(ex.getTargetException() instanceof BurlapRuntimeException)) {
                    if (!(ex.getTargetException() instanceof UndeclaredThrowableException)) throw ex.getTargetException();
                    UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                    throw this.convertBurlapAccessException(utex.getUndeclaredThrowable());
                }
                BurlapRuntimeException bre = (BurlapRuntimeException)ex.getTargetException();
                Object rootCause = bre.getRootCause() != null ? bre.getRootCause() : bre;
                throw this.convertBurlapAccessException((Throwable)rootCause);
            }
            catch (Throwable ex) {
                throw new RemoteProxyFailureException("Failed to invoke Burlap proxy for remote service [" + this.getServiceUrl() + "]", ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.resetThreadContextClassLoader(originalClassLoader);
            throw throwable;
        }
        this.resetThreadContextClassLoader(originalClassLoader);
        return object;
    }

    protected RemoteAccessException convertBurlapAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            return new RemoteConnectFailureException("Cannot connect to Burlap remote service at [" + this.getServiceUrl() + "]", ex);
        }
        return new RemoteAccessException("Cannot access Burlap remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

