/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.jspecify.annotations.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.assertj.AbstractMockHttpServletRequestAssert;
import org.springframework.test.web.servlet.assertj.AbstractMockHttpServletResponseAssert;
import org.springframework.test.web.servlet.assertj.CookieMapAssert;
import org.springframework.test.web.servlet.assertj.HandlerResultAssert;
import org.springframework.test.web.servlet.assertj.ModelAssert;
import org.springframework.test.web.servlet.assertj.MvcTestResult;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.web.servlet.ModelAndView;

public class MvcTestResultAssert
extends AbstractMockHttpServletResponseAssert<MvcTestResultAssert, MvcTestResult> {
    MvcTestResultAssert(MvcTestResult actual, @Nullable JsonConverterDelegate converterDelegate) {
        super(converterDelegate, actual, MvcTestResultAssert.class);
    }

    @Override
    protected MockHttpServletResponse getResponse() {
        return this.getMvcResult().getResponse();
    }

    public AbstractThrowableAssert<?, ? extends Throwable> failure() {
        this.hasFailed();
        return Assertions.assertThat((Throwable)this.getFailure());
    }

    public AbstractMockHttpServletRequestAssert<?> request() {
        return new MockHttpRequestAssert(this.getMvcResult().getRequest());
    }

    public CookieMapAssert cookies() {
        return new CookieMapAssert(this.getMvcResult().getResponse().getCookies());
    }

    public HandlerResultAssert handler() {
        return new HandlerResultAssert(this.getMvcResult().getHandler());
    }

    public ModelAssert model() {
        return new ModelAssert(this.getModelAndView().getModel());
    }

    public AbstractStringAssert<?> viewName() {
        return (AbstractStringAssert)Assertions.assertThat((String)this.getModelAndView().getViewName()).as("View name", new Object[0]);
    }

    public MapAssert<String, Object> flash() {
        return new MapAssert((Map)this.getMvcResult().getFlashMap());
    }

    public MvcTestResultAssert debug() {
        return this.debug(System.out);
    }

    public MvcTestResultAssert debug(OutputStream stream) {
        return this.apply(MockMvcResultHandlers.print(stream));
    }

    public MvcTestResultAssert debug(Writer writer) {
        return this.apply(MockMvcResultHandlers.print(writer));
    }

    public MvcTestResultAssert hasFailed() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)this.getFailure()).withFailMessage("Expected request to fail, but it succeeded", new Object[0])).isNotNull();
        return this;
    }

    public MvcTestResultAssert doesNotHaveFailed() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)this.getFailure()).withFailMessage("Expected request to succeed, but it failed", new Object[0])).isNull();
        return this;
    }

    public MvcTestResultAssert matches(ResultMatcher resultMatcher) {
        MvcResult mvcResult = this.getMvcResult();
        return (MvcTestResultAssert)super.satisfies(new ThrowingConsumer[]{mvcTestResult -> resultMatcher.match(mvcResult)});
    }

    public MvcTestResultAssert apply(ResultHandler resultHandler) {
        MvcResult mvcResult = this.getMvcResult();
        return (MvcTestResultAssert)this.satisfies(new ThrowingConsumer[]{mvcTestResult -> resultHandler.handle(mvcResult)});
    }

    public MvcTestResultAssert hasViewName(String viewName) {
        this.viewName().isEqualTo(viewName);
        return (MvcTestResultAssert)this.myself;
    }

    private @Nullable Throwable getFailure() {
        Exception unresolvedException = ((MvcTestResult)this.actual).getUnresolvedException();
        if (unresolvedException != null) {
            return unresolvedException;
        }
        return ((MvcTestResult)this.actual).getMvcResult().getResolvedException();
    }

    private ModelAndView getModelAndView() {
        ModelAndView modelAndView = this.getMvcResult().getModelAndView();
        ((ObjectAssert)Assertions.assertThat((Object)modelAndView).as("ModelAndView", new Object[0])).isNotNull();
        return modelAndView;
    }

    protected MvcResult getMvcResult() {
        Exception unresolvedException = ((MvcTestResult)this.actual).getUnresolvedException();
        if (unresolvedException != null) {
            throw Failures.instance().failure((AssertionInfo)this.info, (ErrorMessageFactory)new RequestFailedUnexpectedly(unresolvedException));
        }
        return ((MvcTestResult)this.actual).getMvcResult();
    }

    private static final class MockHttpRequestAssert
    extends AbstractMockHttpServletRequestAssert<MockHttpRequestAssert> {
        private MockHttpRequestAssert(MockHttpServletRequest request) {
            super(request, MockHttpRequestAssert.class);
        }
    }

    private static final class RequestFailedUnexpectedly
    extends BasicErrorMessageFactory {
        private RequestFailedUnexpectedly(Exception ex) {
            super("%nRequest failed unexpectedly:%n%s", new Object[]{RequestFailedUnexpectedly.unquotedString((String)RequestFailedUnexpectedly.getIndentedStackTraceAsString(ex))});
        }

        private static String getIndentedStackTraceAsString(Throwable ex) {
            String stackTrace = RequestFailedUnexpectedly.getStackTraceAsString(ex);
            return RequestFailedUnexpectedly.indent(stackTrace);
        }

        private static String getStackTraceAsString(Throwable ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            return writer.toString();
        }

        private static String indent(String input) {
            BufferedReader reader = new BufferedReader(new StringReader(input));
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            reader.lines().forEach(line -> {
                printer.print(" ");
                printer.println((String)line);
            });
            return writer.toString();
        }
    }
}

