/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.Mergeable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.request.ConfigurableSmartRequestBuilder;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractMockHttpServletRequestBuilder<B extends AbstractMockHttpServletRequestBuilder<B>>
implements ConfigurableSmartRequestBuilder<B>,
Mergeable {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private final HttpMethod method;
    private @Nullable String uriTemplate;
    private @Nullable URI uri;
    private String contextPath = "";
    private String servletPath = "";
    private @Nullable String pathInfo = "";
    private @Nullable Boolean secure;
    private @Nullable Principal principal;
    private @Nullable MockHttpSession session;
    private @Nullable String remoteAddress;
    private @Nullable String characterEncoding;
    private byte @Nullable [] content;
    private @Nullable String contentType;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> formFields = new LinkedMultiValueMap();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final List<Locale> locales = new ArrayList<Locale>();
    private @Nullable Object version;
    private @Nullable ApiVersionInserter versionInserter;
    private final Map<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> flashAttributes = new LinkedHashMap<String, Object>();
    private final List<RequestPostProcessor> postProcessors = new ArrayList<RequestPostProcessor>();

    protected AbstractMockHttpServletRequestBuilder(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"'httpMethod' is required");
        this.method = httpMethod;
    }

    protected B self() {
        return (B)this;
    }

    public B uri(URI uri) {
        return this.updateUri(uri, null);
    }

    public B uri(String uriTemplate, Object ... uriVariables) {
        return this.updateUri(AbstractMockHttpServletRequestBuilder.initUri(uriTemplate, uriVariables), uriTemplate);
    }

    private B updateUri(URI uri, @Nullable String uriTemplate) {
        this.uri = uri;
        this.uriTemplate = uriTemplate;
        return this.self();
    }

    private static URI initUri(String uri, @Nullable Object[] vars) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        Assert.isTrue((uri.isEmpty() || uri.startsWith("/") || uri.startsWith("http://") || uri.startsWith("https://") ? 1 : 0) != 0, () -> "'uri' should start with a path or be a complete HTTP URI: " + uri);
        String uriString = uri.isEmpty() ? "/" : uri;
        return UriComponentsBuilder.fromUriString((String)uriString).buildAndExpand(vars).encode().toUri();
    }

    public B contextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath)) {
            Assert.isTrue((boolean)contextPath.startsWith("/"), (String)"Context path must start with a '/'");
            Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, (String)"Context path must not end with a '/'");
        }
        this.contextPath = contextPath;
        return this.self();
    }

    public B servletPath(String servletPath) {
        if (StringUtils.hasText((String)servletPath)) {
            Assert.isTrue((boolean)servletPath.startsWith("/"), (String)"Servlet path must start with a '/'");
            Assert.isTrue((!servletPath.endsWith("/") ? 1 : 0) != 0, (String)"Servlet path must not end with a '/'");
        }
        this.servletPath = servletPath;
        return this.self();
    }

    public B pathInfo(@Nullable String pathInfo) {
        if (StringUtils.hasText((String)pathInfo)) {
            Assert.isTrue((boolean)pathInfo.startsWith("/"), (String)"Path info must start with a '/'");
        }
        this.pathInfo = pathInfo;
        return this.self();
    }

    public B secure(boolean secure) {
        this.secure = secure;
        return this.self();
    }

    public B characterEncoding(Charset encoding) {
        return this.characterEncoding(encoding.name());
    }

    public B characterEncoding(String encoding) {
        this.characterEncoding = encoding;
        return this.self();
    }

    public B content(byte[] content) {
        this.content = content;
        return this.self();
    }

    public B content(String content) {
        this.content = content.getBytes(StandardCharsets.UTF_8);
        return this.self();
    }

    public B contentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentType = contentType.toString();
        return this.self();
    }

    public B contentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentType = contentType;
        return this.self();
    }

    public B accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        this.headers.setAccept(Arrays.asList(mediaTypes));
        return this.self();
    }

    public B accept(String ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        this.headers.set("Accept", String.join((CharSequence)", ", mediaTypes));
        return this.self();
    }

    public B acceptCharset(Charset ... acceptableCharsets) {
        this.headers.setAcceptCharset(Arrays.asList(acceptableCharsets));
        return this.self();
    }

    public B ifModifiedSince(ZonedDateTime ifModifiedSince) {
        this.headers.setIfModifiedSince(ifModifiedSince);
        return this.self();
    }

    public B ifNoneMatch(String ... ifNoneMatches) {
        this.headers.setIfNoneMatch(Arrays.asList(ifNoneMatches));
        return this.self();
    }

    public B header(String name, Object ... values) {
        Object value;
        if (values.length == 1 && (value = values[0]) instanceof Collection) {
            Collection collection = (Collection)value;
            values = collection.toArray();
        }
        for (Object value2 : values) {
            if (value2 instanceof Date) {
                Date date = (Date)value2;
                this.headers.add(name, simpleDateFormat.format(date));
                continue;
            }
            this.headers.add(name, String.valueOf(value2));
        }
        return this.self();
    }

    public B headers(HttpHeaders httpHeaders) {
        httpHeaders.forEach((arg_0, arg_1) -> ((HttpHeaders)this.headers).addAll(arg_0, arg_1));
        return this.self();
    }

    public B headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this.self();
    }

    public B param(String name, String ... values) {
        this.parameters.addAll((Object)name, Arrays.asList(values));
        return this.self();
    }

    public B params(MultiValueMap<String, String> params) {
        params.forEach((name, values) -> {
            for (String value : values) {
                this.parameters.add(name, (Object)value);
            }
        });
        return this.self();
    }

    public B queryParam(String name, String ... values) {
        this.param(name, values);
        this.queryParams.addAll((Object)name, Arrays.asList(values));
        return this.self();
    }

    public B queryParams(MultiValueMap<String, String> params) {
        this.params(params);
        this.queryParams.addAll(params);
        return this.self();
    }

    public B formField(String name, String ... values) {
        this.param(name, values);
        this.formFields.addAll((Object)name, Arrays.asList(values));
        return this.self();
    }

    public B formFields(MultiValueMap<String, String> formFields) {
        this.params(formFields);
        this.formFields.addAll(formFields);
        return this.self();
    }

    public B cookie(Cookie ... cookies) {
        Assert.notEmpty((Object[])cookies, (String)"'cookies' must not be empty");
        this.cookies.addAll(Arrays.asList(cookies));
        return this.self();
    }

    public B locale(Locale ... locales) {
        Assert.notEmpty((Object[])locales, (String)"'locales' must not be empty");
        this.locales.addAll(Arrays.asList(locales));
        return this.self();
    }

    public B locale(@Nullable Locale locale) {
        this.locales.clear();
        if (locale != null) {
            this.locales.add(locale);
        }
        return this.self();
    }

    public B apiVersion(Object version) {
        this.version = version;
        return this.self();
    }

    public B apiVersionInserter(@Nullable ApiVersionInserter versionInserter) {
        this.versionInserter = versionInserter;
        return this.self();
    }

    public B requestAttr(String name, Object value) {
        AbstractMockHttpServletRequestBuilder.addToMap(this.requestAttributes, name, value);
        return this.self();
    }

    public B sessionAttr(String name, Object value) {
        AbstractMockHttpServletRequestBuilder.addToMap(this.sessionAttributes, name, value);
        return this.self();
    }

    public B sessionAttrs(Map<String, Object> sessionAttributes) {
        Assert.notEmpty(sessionAttributes, (String)"'sessionAttributes' must not be empty");
        sessionAttributes.forEach(this::sessionAttr);
        return this.self();
    }

    public B flashAttr(String name, Object value) {
        AbstractMockHttpServletRequestBuilder.addToMap(this.flashAttributes, name, value);
        return this.self();
    }

    public B flashAttrs(Map<String, Object> flashAttributes) {
        Assert.notEmpty(flashAttributes, (String)"'flashAttributes' must not be empty");
        flashAttributes.forEach(this::flashAttr);
        return this.self();
    }

    public B session(MockHttpSession session) {
        Assert.notNull((Object)session, (String)"'session' must not be null");
        this.session = session;
        return this.self();
    }

    public B principal(Principal principal) {
        Assert.notNull((Object)principal, (String)"'principal' must not be null");
        this.principal = principal;
        return this.self();
    }

    public B remoteAddress(String remoteAddress) {
        Assert.hasText((String)remoteAddress, (String)"'remoteAddress' must not be null or blank");
        this.remoteAddress = remoteAddress;
        return this.self();
    }

    @Override
    public B with(RequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"postProcessor is required");
        this.postProcessors.add(postProcessor);
        return this.self();
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(@Nullable Object parent) {
        String attributeName;
        String paramName;
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof AbstractMockHttpServletRequestBuilder)) {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        AbstractMockHttpServletRequestBuilder parentBuilder = (AbstractMockHttpServletRequestBuilder)parent;
        if (this.uri == null) {
            this.uri = parentBuilder.uri;
            this.uriTemplate = parentBuilder.uriTemplate;
        }
        if (!StringUtils.hasText((String)this.contextPath)) {
            this.contextPath = parentBuilder.contextPath;
        }
        if (!StringUtils.hasText((String)this.servletPath)) {
            this.servletPath = parentBuilder.servletPath;
        }
        if ("".equals(this.pathInfo)) {
            this.pathInfo = parentBuilder.pathInfo;
        }
        if (this.secure == null) {
            this.secure = parentBuilder.secure;
        }
        if (this.principal == null) {
            this.principal = parentBuilder.principal;
        }
        if (this.session == null) {
            this.session = parentBuilder.session;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = parentBuilder.remoteAddress;
        }
        if (this.characterEncoding == null) {
            this.characterEncoding = parentBuilder.characterEncoding;
        }
        if (this.content == null) {
            this.content = parentBuilder.content;
        }
        if (this.contentType == null) {
            this.contentType = parentBuilder.contentType;
        }
        parentBuilder.headers.forEach((headerName, values) -> values.forEach(value -> {
            if (!this.headers.containsHeader(headerName)) {
                this.headers.put(headerName, values);
            }
        }));
        for (Map.Entry entry : parentBuilder.parameters.entrySet()) {
            paramName = (String)entry.getKey();
            if (this.parameters.containsKey((Object)paramName)) continue;
            this.parameters.put((Object)paramName, (Object)((List)entry.getValue()));
        }
        for (Map.Entry entry : parentBuilder.queryParams.entrySet()) {
            paramName = (String)entry.getKey();
            if (this.queryParams.containsKey((Object)paramName)) continue;
            this.queryParams.put((Object)paramName, (Object)((List)entry.getValue()));
        }
        for (Map.Entry entry : parentBuilder.formFields.entrySet()) {
            paramName = (String)entry.getKey();
            if (this.formFields.containsKey((Object)paramName)) continue;
            this.formFields.put((Object)paramName, (Object)((List)entry.getValue()));
        }
        for (Cookie cookie : parentBuilder.cookies) {
            if (this.containsCookie(cookie)) continue;
            this.cookies.add(cookie);
        }
        for (Locale locale : parentBuilder.locales) {
            if (this.locales.contains(locale)) continue;
            this.locales.add(locale);
        }
        if (this.version == null) {
            this.version = parentBuilder.version;
        }
        if (this.versionInserter == null) {
            this.versionInserter = parentBuilder.versionInserter;
        }
        for (Map.Entry entry : parentBuilder.requestAttributes.entrySet()) {
            attributeName = (String)entry.getKey();
            if (this.requestAttributes.containsKey(attributeName)) continue;
            this.requestAttributes.put(attributeName, entry.getValue());
        }
        for (Map.Entry entry : parentBuilder.sessionAttributes.entrySet()) {
            attributeName = (String)entry.getKey();
            if (this.sessionAttributes.containsKey(attributeName)) continue;
            this.sessionAttributes.put(attributeName, entry.getValue());
        }
        for (Map.Entry entry : parentBuilder.flashAttributes.entrySet()) {
            attributeName = (String)entry.getKey();
            if (this.flashAttributes.containsKey(attributeName)) continue;
            this.flashAttributes.put(attributeName, entry.getValue());
        }
        this.postProcessors.addAll(0, parentBuilder.postProcessors);
        return this;
    }

    private boolean containsCookie(Cookie cookie) {
        for (Cookie cookieToCheck : this.cookies) {
            if (!ObjectUtils.nullSafeEquals((Object)cookieToCheck.getName(), (Object)cookie.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final MockHttpServletRequest buildRequest(ServletContext servletContext) {
        String requestContentType;
        MediaType mediaType;
        URI uri = this.uri;
        Assert.notNull((Object)uri, (String)"'uri' is required");
        if (this.version != null) {
            Assert.state((this.versionInserter != null ? 1 : 0) != 0, (String)"No ApiVersionInserter");
            uri = this.versionInserter.insertVersion(this.version, uri);
        }
        MockHttpServletRequest request = this.createServletRequest(servletContext);
        request.setAsyncSupported(true);
        request.setMethod(this.method.name());
        request.setUriTemplate(this.uriTemplate);
        String requestUri = uri.getRawPath();
        request.setRequestURI(requestUri);
        if (uri.getScheme() != null) {
            request.setScheme(uri.getScheme());
        }
        if (uri.getHost() != null) {
            request.setServerName(uri.getHost());
        }
        if (uri.getPort() != -1) {
            request.setServerPort(uri.getPort());
        }
        this.updatePathRequestProperties(request, requestUri);
        if (this.secure != null) {
            request.setSecure(this.secure);
        }
        if (this.principal != null) {
            request.setUserPrincipal(this.principal);
        }
        if (this.remoteAddress != null) {
            request.setRemoteAddr(this.remoteAddress);
        }
        if (this.session != null) {
            request.setSession(this.session);
        }
        request.setCharacterEncoding(this.characterEncoding);
        request.setContent(this.content);
        request.setContentType(this.contentType);
        if (this.version != null) {
            Assert.state((this.versionInserter != null ? 1 : 0) != 0, (String)"No ApiVersionInserter");
            this.versionInserter.insertVersion(this.version, this.headers);
        }
        this.headers.forEach((name, values) -> {
            for (Object value : values) {
                request.addHeader((String)name, value);
            }
        });
        if (!(ObjectUtils.isEmpty((Object)this.content) || this.headers.containsHeader("Content-Length") || this.headers.containsHeader("Transfer-Encoding"))) {
            request.addHeader("Content-Length", this.content.length);
        }
        String query = uri.getRawQuery();
        if (!this.queryParams.isEmpty()) {
            String str = UriComponentsBuilder.newInstance().queryParams(this.queryParams).build().encode().getQuery();
            String string = query = StringUtils.hasLength((String)query) ? query + "&" + str : str;
        }
        if (query != null) {
            request.setQueryString(query);
        }
        this.addRequestParams(request, (MultiValueMap<String, String>)UriComponentsBuilder.fromUri((URI)uri).build().getQueryParams());
        this.parameters.forEach((name, values) -> request.addParameter((String)name, values.toArray(new String[0])));
        if (!this.formFields.isEmpty()) {
            if (this.content != null && this.content.length > 0) {
                throw new IllegalStateException("Could not write form data with an existing body");
            }
            Charset charset = this.characterEncoding != null ? Charset.forName(this.characterEncoding) : StandardCharsets.UTF_8;
            MediaType mediaType2 = mediaType = request.getContentType() != null ? MediaType.parseMediaType((String)request.getContentType()) : new MediaType(MediaType.APPLICATION_FORM_URLENCODED, charset);
            if (!mediaType.isCompatibleWith(MediaType.APPLICATION_FORM_URLENCODED)) {
                throw new IllegalStateException("Invalid content type: '" + String.valueOf(mediaType) + "' is not compatible with '" + String.valueOf(MediaType.APPLICATION_FORM_URLENCODED) + "'");
            }
            request.setContent(this.writeFormData(mediaType, charset));
            if (request.getContentType() == null) {
                request.setContentType(mediaType.toString());
            }
        }
        if (this.content != null && this.content.length > 0 && (requestContentType = request.getContentType()) != null) {
            try {
                mediaType = MediaType.parseMediaType((String)requestContentType);
                if (MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType)) {
                    this.addRequestParams(request, this.parseFormData(mediaType));
                }
            }
            catch (Exception mediaType3) {
                // empty catch block
            }
        }
        if (!ObjectUtils.isEmpty(this.cookies)) {
            request.setCookies(this.cookies.toArray(new Cookie[0]));
        }
        if (!ObjectUtils.isEmpty(this.locales)) {
            request.setPreferredLocales(this.locales);
        }
        this.requestAttributes.forEach(request::setAttribute);
        this.sessionAttributes.forEach((name, attribute) -> {
            HttpSession session = request.getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"No HttpSession");
            session.setAttribute(name, attribute);
        });
        FlashMap flashMap = new FlashMap();
        flashMap.putAll(this.flashAttributes);
        FlashMapManager flashMapManager = this.getFlashMapManager(request);
        flashMapManager.saveOutputFlashMap(flashMap, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        return request;
    }

    protected MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        return new MockHttpServletRequest(servletContext);
    }

    private void updatePathRequestProperties(MockHttpServletRequest request, String requestUri) {
        if (!requestUri.startsWith(this.contextPath)) {
            throw new IllegalArgumentException("Request URI [" + requestUri + "] does not start with context path [" + this.contextPath + "]");
        }
        request.setContextPath(this.contextPath);
        request.setServletPath(this.servletPath);
        String path = this.pathInfo;
        if ("".equals(path)) {
            Assert.isTrue((boolean)requestUri.startsWith(this.contextPath + this.servletPath), () -> "Invalid servlet path [" + this.servletPath + "] for request URI [" + requestUri + "]");
            String other = requestUri.substring(this.contextPath.length() + this.servletPath.length());
            path = StringUtils.hasText((String)other) ? UrlPathHelper.defaultInstance.decodeRequestString((HttpServletRequest)request, other) : null;
        }
        request.setPathInfo(path);
    }

    private void addRequestParams(MockHttpServletRequest request, MultiValueMap<String, String> map) {
        map.forEach((key, values) -> request.addParameter(UriUtils.decode((String)key, (Charset)StandardCharsets.UTF_8), (String[])values.stream().map(value -> value != null ? UriUtils.decode((String)value, (Charset)StandardCharsets.UTF_8) : null).toArray(String[]::new)));
    }

    private byte[] writeFormData(final MediaType mediaType, Charset charset) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpOutputMessage message = new HttpOutputMessage(){
            final /* synthetic */ AbstractMockHttpServletRequestBuilder this$0;
            {
                this.this$0 = this$0;
            }

            public OutputStream getBody() {
                return out;
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(mediaType);
                return headers;
            }
        };
        try {
            FormHttpMessageConverter messageConverter = new FormHttpMessageConverter();
            messageConverter.setCharset(charset);
            messageConverter.write(this.formFields, mediaType, message);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write form data to request body", ex);
        }
    }

    private MultiValueMap<String, String> parseFormData(final MediaType mediaType) {
        HttpInputMessage message = new HttpInputMessage(){
            final /* synthetic */ AbstractMockHttpServletRequestBuilder this$0;
            {
                this.this$0 = this$0;
            }

            public InputStream getBody() {
                byte[] bodyContent = this.this$0.content;
                return bodyContent != null ? new ByteArrayInputStream(bodyContent) : InputStream.nullInputStream();
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(mediaType);
                return headers;
            }
        };
        try {
            return new FormHttpMessageConverter().read(null, message);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to parse form data in request body", ex);
        }
    }

    private FlashMapManager getFlashMapManager(MockHttpServletRequest request) {
        SessionFlashMapManager flashMapManager = null;
        try {
            ServletContext servletContext = request.getServletContext();
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            flashMapManager = (FlashMapManager)wac.getBean("flashMapManager", FlashMapManager.class);
        }
        catch (IllegalStateException | NoSuchBeanDefinitionException throwable) {
            // empty catch block
        }
        return flashMapManager != null ? flashMapManager : new SessionFlashMapManager();
    }

    @Override
    public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
        for (RequestPostProcessor postProcessor : this.postProcessors) {
            request = postProcessor.postProcessRequest(request);
        }
        return request;
    }

    private static void addToMap(Map<String, Object> map, String name, Object value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        map.put(name, value);
    }

    static {
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

